<?php require 'views/layouts/header.php'; ?>

<div class="container">
    <h2 class="mb-4">Meus Cursos</h2>
    
    <?php if (count($myCourses) > 0): ?>
        <div class="row">
            <?php foreach ($myCourses as $course): ?>
            <div class="col-md-4 mb-4">
                <div class="card h-100">
                    <?php if($course['image']): ?>
                        <img src="<?php echo asset('../uploads/' . $course['image']); ?>" class="card-img-top" alt="...">
                    <?php else: ?>
                        <div class="bg-secondary text-white text-center py-5">Sem Imagem</div>
                    <?php endif; ?>
                    <div class="card-body">
                        <h5 class="card-title"><?php echo $course['title']; ?></h5>
                        <div class="progress mb-3">
                            <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo $course['progress']; ?>%" aria-valuenow="<?php echo $course['progress']; ?>" aria-valuemin="0" aria-valuemax="100"><?php echo $course['progress']; ?>%</div>
                        </div>
                        <a href="<?php echo url('student/classroom/' . $course['id']); ?>" class="btn btn-primary w-100">Acessar Curso</a>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="alert alert-info">
            Você ainda não está matriculado em nenhum curso. 
            <a href="<?php echo url('courses'); ?>" class="alert-link">Ver cursos disponíveis</a>.
        </div>
    <?php endif; ?>
</div>

<?php require 'views/layouts/footer.php'; ?>
