<?php 
$activePage = 'profile';
require 'views/layouts/header.php'; 
?>

<div class="container-fluid">
    <div class="row">
        <?php 
        // Determinar qual sidebar usar baseada na role
        if (hasRole('admin')) {
            require 'views/layouts/admin_sidebar.php';
        } elseif (hasRole('professor')) {
            require 'views/layouts/professor_sidebar.php';
        } elseif (hasRole('student')) {
            require 'views/layouts/student_sidebar.php';
        } else {
            // Fallback ou sem sidebar para outros (ex: tutor se não tiver sidebar específica ainda)
            // Se tutor tiver sidebar, adicionar aqui.
        }
        ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-4 border-bottom">
                <h1 class="h2">Meu Perfil</h1>
            </div>

            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-white border-bottom-0 pt-4 pb-0">
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 64px; height: 64px; font-size: 24px; font-weight: 600;">
                                    <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
                                </div>
                                <div>
                                    <h4 class="mb-0"><?php echo $user['name']; ?></h4>
                                    <p class="text-muted mb-0"><?php echo ucfirst($user['role']); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="card-body p-4">
                            <?php if (isset($success)): ?>
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <i class="fas fa-check-circle me-2"></i> <?php echo $success; ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <?php endif; ?>

                            <?php if (isset($errors) && count($errors) > 0): ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <ul class="mb-0 list-unstyled">
                                        <?php foreach ($errors as $error): ?>
                                            <li><i class="fas fa-exclamation-circle me-2"></i> <?php echo $error; ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <?php endif; ?>

                            <form action="<?php echo url('profile'); ?>" method="POST" enctype="multipart/form-data">
                                <h5 class="mb-3 text-primary">Foto de Perfil</h5>
                                <div class="mb-4">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            <?php if (isset($user['avatar']) && $user['avatar'] && file_exists('uploads/' . $user['avatar'])): ?>
                                                <img src="<?php echo url('uploads/' . $user['avatar']); ?>" class="rounded-circle" style="width: 80px; height: 80px; object-fit: cover;">
                                            <?php else: ?>
                                                <div class="avatar-circle bg-light text-secondary rounded-circle d-flex align-items-center justify-content-center" style="width: 80px; height: 80px; font-size: 32px;">
                                                    <i class="fas fa-user"></i>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="flex-grow-1">
                                            <label for="avatar" class="form-label">Alterar foto</label>
                                            <input class="form-control" type="file" id="avatar" name="avatar" accept="image/*">
                                            <div class="form-text">Formatos permitidos: JPG, PNG, GIF. Tamanho máximo recomendado: 2MB.</div>
                                        </div>
                                    </div>
                                </div>

                                <h5 class="mb-3 text-primary">Informações Pessoais</h5>
                                <div class="mb-3">
                                    <label for="name" class="form-label">Nome Completo</label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-user text-muted"></i></span>
                                        <input type="text" class="form-control" id="name" name="name" value="<?php echo $user['name']; ?>" required>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="email" class="form-label">Email</label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-envelope text-muted"></i></span>
                                        <input type="email" class="form-control" id="email" name="email" value="<?php echo $user['email']; ?>" required>
                                    </div>
                                </div>

                                <h5 class="mb-3 text-primary">Segurança</h5>
                                <div class="mb-3">
                                    <label for="password" class="form-label">Nova Senha (deixe em branco para manter)</label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-lock text-muted"></i></span>
                                        <input type="password" class="form-control" id="password" name="password">
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="confirm_password" class="form-label">Confirmar Nova Senha</label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-lock text-muted"></i></span>
                                        <input type="password" class="form-control" id="confirm_password" name="confirm_password">
                                    </div>
                                </div>

                                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                                    <button type="submit" class="btn btn-primary px-4">
                                        <i class="fas fa-save me-2"></i> Salvar Alterações
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
