<?php require 'views/layouts/header.php'; ?>

<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Gerenciar Conteúdo: <?php echo $course['title']; ?></h2>
        <div>
            <a href="<?php echo url('course/show/' . $course['id']); ?>" target="_blank" class="btn btn-info text-white"><i class="fas fa-eye"></i> Ver Página</a>
            <?php if(hasRole('admin')): ?>
                <a href="<?php echo url('admin/courses'); ?>" class="btn btn-secondary">Voltar</a>
            <?php else: ?>
                <a href="<?php echo url('professor/courses'); ?>" class="btn btn-secondary">Voltar</a>
            <?php endif; ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">Adicionar Módulo</div>
                <div class="card-body">
                    <form action="<?php echo url('professor/add_module'); ?>" method="POST">
                        <input type="hidden" name="course_id" value="<?php echo $course['id']; ?>">
                        <div class="mb-3">
                            <label class="form-label">Título do Módulo</label>
                            <input type="text" name="title" class="form-control" required placeholder="Ex: Introdução">
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Criar Módulo</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="accordion" id="accordionModules">
                <?php if (count($modules) > 0): ?>
                    <?php foreach ($modules as $index => $module): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading<?php echo $module['id']; ?>">
                            <button class="accordion-button <?php echo $index > 0 ? 'collapsed' : ''; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $module['id']; ?>">
                                <?php echo $module['title']; ?>
                            </button>
                        </h2>
                        <div id="collapse<?php echo $module['id']; ?>" class="accordion-collapse collapse <?php echo $index === 0 ? 'show' : ''; ?>" data-bs-parent="#accordionModules">
                            <div class="accordion-body">
                                <ul class="list-group mb-3">
                                    <?php if(isset($module['lessons']) && count($module['lessons']) > 0): ?>
                                        <?php foreach($module['lessons'] as $lesson): ?>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <div>
                                                    <i class="fas fa-<?php echo $lesson['type'] == 'video' ? 'video' : 'file-alt'; ?> text-muted me-2"></i>
                                                    <?php echo $lesson['title']; ?>
                                                </div>
                                                <span class="badge bg-secondary"><?php echo ucfirst($lesson['type']); ?></span>
                                            </li>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <li class="list-group-item text-muted">Nenhuma aula neste módulo.</li>
                                    <?php endif; ?>
                                </ul>

                                <button class="btn btn-sm btn-outline-success" type="button" data-bs-toggle="collapse" data-bs-target="#addLessonForm<?php echo $module['id']; ?>">
                                    <i class="fas fa-plus"></i> Adicionar Aula
                                </button>

                                <div class="collapse mt-3" id="addLessonForm<?php echo $module['id']; ?>">
                                    <div class="card card-body bg-light">
                                        <form action="<?php echo url('professor/add_lesson'); ?>" method="POST">
                                            <input type="hidden" name="course_id" value="<?php echo $course['id']; ?>">
                                            <input type="hidden" name="module_id" value="<?php echo $module['id']; ?>">
                                            
                                            <div class="mb-2">
                                                <input type="text" name="title" class="form-control form-control-sm" placeholder="Título da Aula" required>
                                            </div>
                                            <div class="mb-2">
                                                <select name="type" class="form-select form-select-sm">
                                                    <option value="video">Vídeo (URL)</option>
                                                    <option value="text">Texto/Conteúdo</option>
                                                    <option value="pdf">PDF (Link)</option>
                                                </select>
                                            </div>
                                            <div class="mb-2">
                                                <textarea name="content" class="form-control form-control-sm" placeholder="Cole aqui a URL do vídeo ou o conteúdo em texto" required></textarea>
                                            </div>
                                            <button type="submit" class="btn btn-sm btn-success">Salvar Aula</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="alert alert-info">Comece criando o primeiro módulo do seu curso.</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
