<?php require 'views/layouts/header.php'; ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header bg-primary text-white text-center">
                    <h4 class="mb-0"><i class="fas fa-shopping-cart me-2"></i>Finalizar Compra</h4>
                </div>
                <div class="card-body">
                    <h5 class="card-title text-center mb-4"><?php echo $course['title']; ?></h5>
                    <div class="text-center mb-4">
                        <span class="display-4 fw-bold text-primary">R$ <?php echo number_format($course['price'], 2, ',', '.'); ?></span>
                    </div>
                    
                    <hr class="my-4">
                    
                    <h6 class="mb-3 text-muted text-uppercase small fw-bold">Escolha a forma de pagamento:</h6>
                    
                    <!-- Mercado Pago -->
                    <div class="d-grid gap-2 mb-3">
                        <a href="<?php echo url('payment/process_mercadopago/' . $course['id']); ?>" class="btn btn-primary btn-lg p-3">
                            <div class="d-flex align-items-center justify-content-center">
                                <i class="fas fa-credit-card fa-2x me-3"></i>
                                <div class="text-start">
                                    <div class="fw-bold">Mercado Pago</div>
                                    <div class="small" style="font-size: 0.75rem;">Cartão, Boleto ou Pix Automático</div>
                                </div>
                            </div>
                        </a>
                    </div>
                    
                    <!-- Pix Manual -->
                    <?php if(get_setting('pix_manual_active')): ?>
                    <div class="accordion" id="accordionPayment">
                        <div class="accordion-item border-success">
                            <h2 class="accordion-header" id="headingPix">
                                <button class="accordion-button collapsed bg-success text-white" type="button" data-bs-toggle="collapse" data-bs-target="#collapsePix" aria-expanded="false" aria-controls="collapsePix">
                                    <i class="fab fa-pix me-2 fa-lg"></i> Pix (Liberação Manual)
                                </button>
                            </h2>
                            <div id="collapsePix" class="accordion-collapse collapse" aria-labelledby="headingPix" data-bs-parent="#accordionPayment">
                                <div class="accordion-body">
                                    <div class="alert alert-light border border-success text-center">
                                        <p class="mb-2"><strong>Chave Pix (<?php echo strtoupper(get_setting('pix_key_type')); ?>):</strong></p>
                                        <div class="input-group mb-3">
                                            <input type="text" class="form-control text-center fw-bold text-success" value="<?php echo get_setting('pix_key'); ?>" id="pixKey" readonly>
                                            <button class="btn btn-outline-success" type="button" onclick="copyPixKey()">
                                                <i class="fas fa-copy"></i> Copiar
                                            </button>
                                        </div>
                                        
                                        <?php if(get_setting('pix_beneficiary')): ?>
                                        <p class="mb-1 small">Beneficiário: <strong><?php echo get_setting('pix_beneficiary'); ?></strong></p>
                                        <?php endif; ?>
                                        
                                        <?php if(get_setting('pix_instructions')): ?>
                                        <div class="mt-3 small text-start bg-white p-2 rounded border">
                                            <?php echo nl2br(get_setting('pix_instructions')); ?>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <hr>
                                    
                                    <form action="<?php echo url('payment/process_pix_manual/' . $course['id']); ?>" method="POST" enctype="multipart/form-data">
                                        <div class="mb-3">
                                            <label for="receipt" class="form-label fw-bold">Envie o Comprovante</label>
                                            <input class="form-control" type="file" id="receipt" name="receipt" accept="image/*,application/pdf" required>
                                            <div class="form-text">Formatos aceitos: JPG, PNG, PDF.</div>
                                        </div>
                                        <div class="d-grid">
                                            <button type="submit" class="btn btn-success">
                                                <i class="fas fa-upload me-2"></i> Enviar Comprovante e Finalizar
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                </div>
                <div class="card-footer text-muted text-center small">
                    <i class="fas fa-lock me-1"></i> Pagamento 100% Seguro
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyPixKey() {
    var copyText = document.getElementById("pixKey");
    copyText.select();
    copyText.setSelectionRange(0, 99999); /* For mobile devices */
    navigator.clipboard.writeText(copyText.value);
    alert("Chave Pix copiada!");
}
</script>

<?php require 'views/layouts/footer.php'; ?>