<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cursos Online - Sua Plataforma de Ensino</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo url('assets/css/style.css'); ?>">
</head>
<body class="bg-light">

<?php if(get_setting('promo_bar_active')): ?>
<div class="promo-bar py-2 text-center fw-bold" style="background-color: <?php echo get_setting('promo_bar_bg') ?: '#dc3545'; ?>; color: <?php echo get_setting('promo_bar_color') ?: '#ffffff'; ?>;">
    <div class="container">
        <i class="fas fa-bullhorn me-2"></i>
        <?php echo get_setting('promo_bar_text') ?: 'Aproveite nossas promoções!'; ?>
        <?php if(get_setting('promo_bar_link')): ?>
            <a href="<?php echo get_setting('promo_bar_link'); ?>" class="btn btn-sm btn-light ms-2 fw-bold text-uppercase" style="font-size: 0.75rem; color: <?php echo get_setting('promo_bar_bg') ?: '#dc3545'; ?>;">
                Confira
            </a>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>

<?php
$siteName = get_setting('site_name') ?: 'PortalEduca';
$siteLogo = get_setting('site_logo');
?>

<header class="bg-white shadow-sm sticky-top">
    <!-- Top Bar -->
    <div class="bg-light py-2 border-bottom d-none d-md-block">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center small text-muted">
                <div>
                    <i class="fas fa-phone-alt me-2"></i> 11 2364.6184
                    <span class="mx-3">|</span>
                    <i class="fas fa-envelope me-2"></i> contato@cursosonline.com.br
                </div>
                <div>
                    <a href="#" class="text-muted text-decoration-none me-3"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="text-muted text-decoration-none me-3"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="text-muted text-decoration-none"><i class="fab fa-linkedin-in"></i></a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Header -->
    <div class="container py-3">
        <div class="row align-items-center">
            <!-- Logo -->
            <div class="col-md-3 mb-3 mb-md-0">
                <a href="<?php echo url(''); ?>" class="text-decoration-none">
                    <?php if ($siteLogo): ?>
                        <img src="<?php echo url('uploads/' . $siteLogo); ?>" alt="<?php echo $siteName; ?>" style="max-height: 50px;">
                    <?php else: ?>
                        <h2 class="m-0 fw-bold text-primary">
                            <i class="fas fa-graduation-cap me-2"></i><?php echo $siteName; ?>
                        </h2>
                    <?php endif; ?>
                </a>
            </div>

            <!-- Search Bar (Hidden on mobile, visible on desktop) -->
            <div class="col-md-5 mb-3 mb-md-0 d-none d-md-block">
                <form action="<?php echo url('courses'); ?>" method="GET">
                    <div class="input-group">
                        <input type="text" class="form-control bg-light border-end-0" placeholder="O que você quer aprender hoje?" name="search">
                        <button class="btn btn-light border border-start-0" type="submit">
                            <i class="fas fa-search text-muted"></i>
                        </button>
                    </div>
                </form>
            </div>

            <!-- Actions -->
            <div class="col-md-4 text-md-end">
                <div class="d-flex justify-content-md-end gap-2 align-items-center">
                    <?php if (isLoggedIn()): ?>
                        <div class="dropdown">
                            <button class="btn btn-outline-primary dropdown-toggle" type="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-user-circle me-1"></i> <?php echo $_SESSION['user_name']; ?>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                                <?php 
                                    $role = $_SESSION['user_role']; 
                                    $dashboardLink = $role == 'student' ? 'student' : ($role == 'professor' ? 'professor' : ($role == 'tutor' ? 'tutor' : 'admin'));
                                ?>
                                <li><a class="dropdown-item" href="<?php echo url($dashboardLink); ?>">Meu Painel</a></li>
                                <li><a class="dropdown-item" href="<?php echo url('profile'); ?>">Meu Perfil</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-danger" href="<?php echo url('logout'); ?>">Sair</a></li>
                            </ul>
                        </div>
                    <?php else: ?>
                        <a href="<?php echo url('login'); ?>" class="btn btn-outline-primary fw-bold">
                            <i class="fas fa-sign-in-alt me-1"></i> Entrar
                        </a>
                        <a href="<?php echo url('register'); ?>" class="btn btn-primary fw-bold">
                            <i class="fas fa-user-plus me-1"></i> Cadastre-se
                        </a>
                    <?php endif; ?>
                    
                    <a href="#" class="btn btn-light position-relative ms-2 text-primary">
                        <i class="fas fa-shopping-cart fa-lg"></i>
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" style="font-size: 0.6rem;">
                            0
                        </span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Navigation Menu -->
    <div class="bg-primary shadow-sm">
        <div class="container">
            <nav class="navbar navbar-expand-lg navbar-dark p-0">
                <button class="navbar-toggler my-2" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="mainNavbar">
                    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                        <?php 
                        $mainMenu = get_menu('header_main');
                        if (!empty($mainMenu)):
                            foreach($mainMenu as $item): 
                        ?>
                            <li class="nav-item">
                                <a class="nav-link text-white fw-bold px-3 py-3" href="<?php echo $item['link']; ?>"><?php echo $item['label']; ?></a>
                            </li>
                        <?php 
                            endforeach; 
                        else:
                        ?>
                            <li class="nav-item"><a class="nav-link text-white fw-bold px-3 py-3" href="<?php echo url(''); ?>">Home</a></li>
                            <li class="nav-item"><a class="nav-link text-white fw-bold px-3 py-3" href="<?php echo url('#cursos'); ?>">Cursos</a></li>
                            <li class="nav-item"><a class="nav-link text-white fw-bold px-3 py-3" href="<?php echo url('page/sobre'); ?>">Sobre Nós</a></li>
                            <li class="nav-item"><a class="nav-link text-white fw-bold px-3 py-3" href="<?php echo url('page/contato'); ?>">Contato</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </nav>
        </div>
    </div>
</header>
