<?php require 'views/layouts/header.php'; ?>

<div class="py-5 bg-light">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="text-center mb-5">
                    <h1 class="fw-bold mb-3">Consultar Certificado</h1>
                    <p class="lead text-muted">Verifique a autenticidade dos certificados emitidos pela nossa plataforma.</p>
                </div>

                <div class="card shadow-sm border-0 mb-5">
                    <div class="card-body p-4 p-md-5">
                        <form action="<?php echo url('validate_certificate'); ?>" method="GET" class="row g-3">
                            <div class="col-md-9">
                                <div class="form-floating">
                                    <input type="text" class="form-control form-control-lg" id="code" name="code" placeholder="Código do Certificado" value="<?php echo isset($_GET['code']) ? htmlspecialchars($_GET['code']) : ''; ?>" required>
                                    <label for="code">Código de Autenticidade</label>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-primary btn-lg w-100 h-100">
                                    <i class="fas fa-search me-2"></i>Pesquisar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <?php if (isset($result) && $result): ?>
                    <div class="card shadow border-success border-2">
                        <div class="card-header bg-success text-white py-3">
                            <div class="d-flex align-items-center justify-content-center">
                                <i class="fas fa-check-circle fa-2x me-3"></i>
                                <h4 class="m-0 fw-bold">Certificado Válido</h4>
                            </div>
                        </div>
                        <div class="card-body p-4 p-md-5">
                            <div class="text-center mb-4">
                                <div class="display-6 fw-bold text-primary mb-2"><?php echo $result['student_name']; ?></div>
                                <p class="text-muted">Aluno(a)</p>
                            </div>
                            
                            <hr class="my-4">

                            <div class="row g-4">
                                <div class="col-md-6">
                                    <h6 class="text-uppercase text-muted fw-bold small">Curso</h6>
                                    <p class="fs-5 fw-medium mb-0"><?php echo $result['course_title']; ?></p>
                                </div>
                                <div class="col-md-3">
                                    <h6 class="text-uppercase text-muted fw-bold small">Carga Horária</h6>
                                    <p class="fs-5 fw-medium mb-0"><?php echo $result['course_hours']; ?> horas</p>
                                </div>
                                <div class="col-md-3">
                                    <h6 class="text-uppercase text-muted fw-bold small">Data de Conclusão</h6>
                                    <p class="fs-5 fw-medium mb-0"><?php echo date('d/m/Y', strtotime($result['completion_date'])); ?></p>
                                </div>
                            </div>

                            <div class="mt-4 pt-3 text-center">
                                <p class="text-muted small m-0">
                                    Código de Autenticidade: <strong><?php echo $result['certificate_code']; ?></strong>
                                </p>
                            </div>
                        </div>
                    </div>
                <?php elseif (isset($error)): ?>
                    <div class="alert alert-danger d-flex align-items-center p-4 shadow-sm" role="alert">
                        <i class="fas fa-exclamation-triangle fa-2x me-3"></i>
                        <div>
                            <h4 class="alert-heading fw-bold mb-1">Certificado Inválido</h4>
                            <p class="mb-0"><?php echo $error; ?></p>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<div class="py-5 bg-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5 mb-4 mb-lg-0">
                <span class="badge bg-warning text-dark mb-3">Código de Autenticidade</span>
                <h2 class="fw-bold mb-3">Segurança para quem emite e quem recebe o certificado.</h2>
                <p class="text-muted fs-5">
                    Os certificados emitidos em nossa plataforma possuem Chave única de autenticidade e QR Code. Duas garantias de validade do certificado para alunos, empresas e instituições interessadas em verificar a veracidade do mesmo.
                </p>
            </div>
            <div class="col-lg-6 offset-lg-1">
                <div class="p-4 bg-warning bg-opacity-10 rounded-3">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <img src="https://ui-avatars.com/api/?name=Ajuda&background=random&size=64" class="rounded-circle" alt="Ajuda">
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h5 class="fw-bold mb-1">Tem alguma dúvida sobre a Plataforma?</h5>
                            <a href="#" class="btn btn-primary mt-2">Buscar Informações</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
