<?php require 'views/layouts/header.php'; ?>

<div class="bg-primary text-white py-5 mb-5">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-2">
                <li class="breadcrumb-item"><a href="<?php echo url('courses'); ?>" class="text-white-50 text-decoration-none">Cursos</a></li>
                <li class="breadcrumb-item active text-white" aria-current="page"><?php echo $course['title']; ?></li>
            </ol>
        </nav>
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h1 class="display-4 fw-bold mb-3"><?php echo $course['title']; ?></h1>
                <p class="lead mb-4 opacity-75"><?php echo substr($course['description'], 0, 150) . '...'; ?></p>
                <div class="d-flex align-items-center gap-4 text-white-50">
                    <div class="d-flex align-items-center">
                        <div class="avatar-circle bg-white text-primary rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px; font-weight: bold;">
                            <?php echo strtoupper(substr($course['teacher_name'], 0, 1)); ?>
                        </div>
                        <span><?php echo $course['teacher_name']; ?></span>
                    </div>
                    <div class="d-flex align-items-center">
                        <i class="fas fa-tag me-2"></i>
                        <span><?php echo $course['category_name']; ?></span>
                    </div>
                    <div class="d-flex align-items-center">
                        <i class="fas fa-star text-warning me-2"></i>
                        <span>4.8 (120 avaliações)</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container">
    <div class="row">
        <div class="col-lg-8">
            <div class="mb-5">
                <h3 class="fw-bold mb-3">Sobre o Curso</h3>
                <p class="lead text-muted"><?php echo nl2br($course['description']); ?></p>
            </div>

            <?php if (!empty($course['what_will_i_learn'])): ?>
            <div class="mb-5">
                <h3 class="fw-bold mb-3">O que você aprenderá</h3>
                <div class="card border-0 bg-light">
                    <div class="card-body p-4">
                        <div class="row">
                            <?php 
                            $items = explode("\n", $course['what_will_i_learn']);
                            foreach($items as $item): 
                                if(trim($item) == '') continue;
                            ?>
                            <div class="col-md-6 mb-2">
                                <div class="d-flex">
                                    <i class="fas fa-check text-success mt-1 me-2"></i>
                                    <span><?php echo trim($item); ?></span>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if (!empty($course['target_audience'])): ?>
            <div class="mb-5">
                <h3 class="fw-bold mb-3">Para quem é este curso?</h3>
                <ul class="list-unstyled">
                    <?php 
                    $items = explode("\n", $course['target_audience']);
                    foreach($items as $item): 
                        if(trim($item) == '') continue;
                    ?>
                    <li class="mb-2 d-flex">
                        <i class="fas fa-user-check text-primary mt-1 me-2"></i>
                        <span><?php echo trim($item); ?></span>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>

            <?php if (!empty($course['requirements'])): ?>
            <div class="mb-5">
                <h3 class="fw-bold mb-3">Requisitos</h3>
                <ul class="list-unstyled">
                    <?php 
                    $items = explode("\n", $course['requirements']);
                    foreach($items as $item): 
                        if(trim($item) == '') continue;
                    ?>
                    <li class="mb-2 d-flex">
                        <i class="fas fa-info-circle text-info mt-1 me-2"></i>
                        <span><?php echo trim($item); ?></span>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>

            <div class="mb-5">
                <h3 class="fw-bold mb-3">Conteúdo Programático</h3>
                <div class="accordion accordion-flush border rounded-3 overflow-hidden" id="accordionModules">
                    <?php if (count($modules) > 0): ?>
                        <?php foreach ($modules as $index => $module): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="heading<?php echo $module['id']; ?>">
                                <button class="accordion-button <?php echo $index > 0 ? 'collapsed' : ''; ?> fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $module['id']; ?>">
                                    <?php echo $module['title']; ?>
                                </button>
                            </h2>
                            <div id="collapse<?php echo $module['id']; ?>" class="accordion-collapse collapse <?php echo $index === 0 ? 'show' : ''; ?>" data-bs-parent="#accordionModules">
                                <div class="accordion-body bg-light">
                                    <ul class="list-unstyled mb-0">
                                        <?php if(isset($module['lessons']) && count($module['lessons']) > 0): ?>
                                            <?php foreach($module['lessons'] as $lesson): ?>
                                            <li class="py-2 d-flex align-items-center justify-content-between border-bottom border-light last-border-0">
                                                <div>
                                                    <i class="fas fa-<?php echo $lesson['type'] == 'video' ? 'play-circle' : 'file-alt'; ?> text-primary me-3"></i>
                                                    <?php echo $lesson['title']; ?>
                                                </div>
                                                <?php if(!empty($lesson['duration'])): ?>
                                                    <span class="badge bg-light text-secondary border"><?php echo $lesson['duration']; ?></span>
                                                <?php endif; ?>
                                            </li>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <li class="text-muted small">Em breve.</li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="p-4 text-center text-muted">
                            Conteúdo sendo atualizado.
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="mb-5">
                <h3 class="fw-bold mb-4">Avaliações de Alunos</h3>
                
                <?php if(isLoggedIn()): ?>
                    <?php
                    // Verificar se o aluno já comprou para exibir formulário
                    global $pdo;
                    $uid = $_SESSION['user_id'];
                    $hasBought = $pdo->query("SELECT count(*) FROM orders WHERE user_id = $uid AND course_id = {$course['id']} AND status = 'approved'")->fetchColumn();
                    $hasReviewed = $pdo->query("SELECT count(*) FROM reviews WHERE user_id = $uid AND course_id = {$course['id']}")->fetchColumn();
                    ?>

                    <?php if($hasBought && !$hasReviewed): ?>
                    <div class="card mb-4 border-0 shadow-sm bg-light">
                        <div class="card-body p-4">
                            <h5 class="mb-3">Como foi sua experiência?</h5>
                            <form action="<?php echo url('student/save_review'); ?>" method="POST">
                                <input type="hidden" name="course_id" value="<?php echo $course['id']; ?>">
                                <div class="mb-3">
                                    <div class="rating-select d-flex gap-2 text-warning display-6 mb-2">
                                        <!-- Estrelas aqui seriam ideais com JS, mas select é funcional -->
                                    </div>
                                    <select name="rating" class="form-select w-auto" required>
                                        <option value="" selected disabled>Selecione uma nota</option>
                                        <option value="5">⭐⭐⭐⭐⭐ Excelente</option>
                                        <option value="4">⭐⭐⭐⭐ Muito Bom</option>
                                        <option value="3">⭐⭐⭐ Bom</option>
                                        <option value="2">⭐⭐ Regular</option>
                                        <option value="1">⭐ Ruim</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <textarea name="comment" class="form-control" rows="3" placeholder="Escreva seu comentário..." required></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary">Enviar Avaliação</button>
                            </form>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>

                <div class="vstack gap-3">
                    <?php if (count($reviews) > 0): ?>
                        <?php foreach ($reviews as $review): ?>
                            <div class="card border-0 shadow-sm">
                                <div class="card-body p-4">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-circle bg-light text-secondary rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 48px; height: 48px; font-weight: bold;">
                                                <?php echo strtoupper(substr($review['user_name'], 0, 1)); ?>
                                            </div>
                                            <div>
                                                <h6 class="mb-0 fw-bold"><?php echo $review['user_name']; ?></h6>
                                                <small class="text-muted"><?php echo date('d/m/Y', strtotime($review['created_at'])); ?></small>
                                            </div>
                                        </div>
                                        <div class="text-warning">
                                            <?php for($i=0; $i<$review['rating']; $i++) echo '<i class="fas fa-star"></i>'; ?>
                                            <?php for($i=$review['rating']; $i<5; $i++) echo '<i class="far fa-star"></i>'; ?>
                                        </div>
                                    </div>
                                    <p class="card-text text-secondary ps-5 ms-3"><?php echo $review['comment']; ?></p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="text-center py-5 bg-light rounded-3">
                            <i class="far fa-comment-dots fa-3x text-muted mb-3 opacity-50"></i>
                            <p class="text-muted mb-0">Seja o primeiro a avaliar este curso!</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        </div>
        
        <div class="col-lg-4">
            <div class="card border-0 shadow sticky-top" style="top: 100px; z-index: 10;">
                <?php if($course['image']): ?>
                    <img src="<?php echo asset('uploads/' . $course['image']); ?>" class="card-img-top" alt="<?php echo $course['title']; ?>" style="height: 240px; object-fit: cover;">
                <?php else: ?>
                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 240px;">
                        <i class="fas fa-book-open fa-4x text-secondary opacity-50"></i>
                    </div>
                <?php endif; ?>
                
                <div class="card-body p-4">
                    <div class="d-flex align-items-end mb-3">
                        <h2 class="card-title text-primary fw-bold mb-0 me-2">R$ <?php echo number_format($course['price'], 2, ',', '.'); ?></h2>
                        <span class="text-muted text-decoration-line-through mb-1">R$ <?php echo number_format($course['price'] * 1.5, 2, ',', '.'); ?></span>
                    </div>
                    
                    <div class="d-grid gap-2 mb-4">
                        <?php if (isLoggedIn()): ?>
                            <?php 
                                global $pdo;
                                $userId = $_SESSION['user_id'];
                                $check = $pdo->prepare("SELECT * FROM enrollments WHERE user_id = :uid AND course_id = :cid");
                                $check->execute(['uid' => $userId, 'cid' => $course['id']]);
                                if ($check->rowCount() > 0): 
                            ?>
                                <a href="<?php echo url('student/classroom/' . $course['id']); ?>" class="btn btn-outline-primary btn-lg fw-bold">
                                    <i class="fas fa-play-circle me-2"></i> Continuar Estudando
                                </a>
                            <?php else: ?>
                                <a href="<?php echo url('payment/checkout/' . $course['id']); ?>" class="btn btn-primary btn-lg fw-bold pulse-animation">
                                    Comprar Agora
                                </a>
                            <?php endif; ?>
                        <?php else: ?>
                            <a href="<?php echo url('login'); ?>" class="btn btn-primary btn-lg fw-bold pulse-animation">
                                Comprar Agora
                            </a>
                        <?php endif; ?>
                    </div>
                    
                    <div class="mb-4">
                        <h6 class="fw-bold mb-3">Este curso inclui:</h6>
                        <ul class="list-unstyled vstack gap-2">
                            <li class="d-flex align-items-center text-secondary">
                                <i class="fas fa-video text-primary me-3" style="width: 20px;"></i> 
                                <span>Acesso vitalício</span>
                            </li>
                            <li class="d-flex align-items-center text-secondary">
                                <i class="fas fa-mobile-alt text-primary me-3" style="width: 20px;"></i> 
                                <span>Acesso no celular e TV</span>
                            </li>
                            <li class="d-flex align-items-center text-secondary">
                                <i class="fas fa-certificate text-primary me-3" style="width: 20px;"></i> 
                                <span>Certificado de conclusão</span>
                            </li>
                            <li class="d-flex align-items-center text-secondary">
                                <i class="fas fa-comments text-primary me-3" style="width: 20px;"></i> 
                                <span>Suporte direto com professor</span>
                            </li>
                            <li class="d-flex align-items-center text-secondary mt-2">
                                <i class="fas fa-id-card text-primary me-3" style="width: 20px;"></i> 
                                <span>E também receberá uma carteirinha de estudante!</span>
                            </li>
                            <li class="d-flex align-items-center fw-bold text-primary mt-1">
                                <i class="fas fa-clock text-primary me-3" style="width: 20px;"></i> 
                                <span>Carga Horária: <?php echo isset($course['duration']) ? $course['duration'] : '20 Horas'; ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.last-border-0:last-child {
    border-bottom: 0 !important;
}
@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.02); }
    100% { transform: scale(1); }
}
.pulse-animation:hover {
    animation: pulse 1s infinite;
}
</style>

<?php require 'views/layouts/footer.php'; ?>
