<?php require 'views/layouts/header.php'; ?>

<div class="container">
    <h2 class="mb-4">Todos os Cursos</h2>
    
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex gap-2 overflow-auto py-2">
                <a href="<?php echo url('courses'); ?>" class="btn btn-outline-primary <?php echo !isset($_GET['category']) ? 'active' : ''; ?>">Todos</a>
                <?php foreach($categories as $cat): ?>
                    <a href="<?php echo url('courses?category=' . $cat['id']); ?>" class="btn btn-outline-primary <?php echo (isset($_GET['category']) && $_GET['category'] == $cat['id']) ? 'active' : ''; ?>">
                        <?php echo $cat['name']; ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    
    <div class="row">
        <?php if (count($courses) > 0): ?>
            <?php foreach ($courses as $course): ?>
                <div class="col-md-4 mb-4">
                    <div class="card h-100 shadow-sm">
                         <?php if($course['image']): ?>
                            <img src="<?php echo url('uploads/' . $course['image']); ?>" class="card-img-top" alt="<?php echo $course['title']; ?>" style="height: 200px; object-fit: cover;">
                        <?php else: ?>
                            <div class="bg-secondary text-white d-flex align-items-center justify-content-center" style="height: 200px;">
                                <i class="fas fa-book-open fa-3x"></i>
                            </div>
                        <?php endif; ?>
                        <div class="card-body">
                            <span class="badge bg-info text-dark mb-2"><?php echo $course['category_name']; ?></span>
                            <h5 class="card-title"><?php echo $course['title']; ?></h5>
                            <p class="card-text text-truncate"><?php echo $course['description']; ?></p>
                            <div class="d-flex justify-content-between align-items-center mt-3">
                                <span class="h5 mb-0 text-success">R$ <?php echo number_format($course['price'], 2, ',', '.'); ?></span>
                                <small class="text-muted">Prof. <?php echo $course['teacher_name']; ?></small>
                            </div>
                        </div>
                        <div class="card-footer bg-white border-top-0">
                            <a href="<?php echo url('course/show/' . $course['id']); ?>" class="btn btn-primary w-100">Ver Detalhes</a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="col-12">
                <div class="alert alert-info">Nenhum curso encontrado nesta categoria.</div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
