<?php require 'views/layouts/header.php'; ?>

<div class="row">
    <div class="col-md-3">
        <?php require 'views/layouts/admin_sidebar.php'; ?>
    </div>
    <div class="col-md-9">
        <h2 class="mb-4">Matrícula Manual (Abonar Curso)</h2>
        
        <?php if (isset($success)): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <div class="card shadow">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Abonar Curso para Aluno</h6>
            </div>
            <div class="card-body">
                <p class="text-muted">Utilize esta opção para matricular um aluno em um curso sem custo (bolsa/abono).</p>
                
                <form action="<?php echo url('admin/manual_enroll'); ?>" method="POST">
                    <div class="mb-3">
                        <label for="user_id" class="form-label">Selecione o Aluno</label>
                        <select class="form-select" id="user_id" name="user_id" required>
                            <option value="">Selecione...</option>
                            <?php foreach ($users as $user): ?>
                                <option value="<?php echo $user['id']; ?>">
                                    <?php echo htmlspecialchars($user['name']); ?> (<?php echo htmlspecialchars($user['email']); ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="course_id" class="form-label">Selecione o Curso</label>
                        <select class="form-select" id="course_id" name="course_id" required>
                            <option value="">Selecione...</option>
                            <?php foreach ($courses as $course): ?>
                                <option value="<?php echo $course['id']; ?>">
                                    <?php echo htmlspecialchars($course['title']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-check-circle me-2"></i>Realizar Matrícula
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>