<?php require 'views/layouts/header.php'; ?>
<?php $activePage = 'id_card_settings'; ?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/admin_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <h2 class="h3 mb-4 text-gray-800">Configuração da Carteirinha de Estudante</h2>

            <form action="<?php echo url('admin/id_card_settings'); ?>" method="POST" enctype="multipart/form-data">
                
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Configurações Gerais</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="id_card_active" name="id_card_active" value="1" <?php echo get_setting('id_card_active') ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="id_card_active">Ativar Emissão de Carteirinha</label>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="id_card_school_name" class="form-label">Nome da Instituição</label>
                                <input type="text" class="form-control" id="id_card_school_name" name="id_card_school_name" value="<?php echo htmlspecialchars(get_setting('id_card_school_name')); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="id_card_validity_months" class="form-label">Validade (meses)</label>
                                <input type="number" class="form-control" id="id_card_validity_months" name="id_card_validity_months" value="<?php echo htmlspecialchars(get_setting('id_card_validity_months')); ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="id_card_layout_color" class="form-label">Cor Principal (Bordas/Títulos)</label>
                                <input type="color" class="form-control form-control-color" id="id_card_layout_color" name="id_card_layout_color" value="<?php echo htmlspecialchars(get_setting('id_card_layout_color')); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="id_card_text_color" class="form-label">Cor do Texto</label>
                                <input type="color" class="form-control form-control-color" id="id_card_text_color" name="id_card_text_color" value="<?php echo htmlspecialchars(get_setting('id_card_text_color')); ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="card shadow mb-4">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">Frente da Carteirinha</h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="id_card_bg_front" class="form-label">Imagem de Fundo (Frente)</label>
                                    <input class="form-control" type="file" id="id_card_bg_front" name="id_card_bg_front" accept="image/*">
                                    <small class="text-muted">Recomendado: 600x380px</small>
                                    <?php if (get_setting('id_card_bg_front')): ?>
                                        <div class="mt-2 text-center">
                                            <img src="<?php echo url('uploads/' . get_setting('id_card_bg_front')); ?>" alt="Fundo Frente" class="img-fluid rounded border" style="max-height: 200px;">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card shadow mb-4">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">Verso da Carteirinha</h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="id_card_bg_back" class="form-label">Imagem de Fundo (Verso)</label>
                                    <input class="form-control" type="file" id="id_card_bg_back" name="id_card_bg_back" accept="image/*">
                                    <small class="text-muted">Recomendado: 600x380px</small>
                                    <?php if (get_setting('id_card_bg_back')): ?>
                                        <div class="mt-2 text-center">
                                            <img src="<?php echo url('uploads/' . get_setting('id_card_bg_back')); ?>" alt="Fundo Verso" class="img-fluid rounded border" style="max-height: 200px;">
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-4">
                    <button type="submit" class="btn btn-success btn-lg"><i class="fas fa-save me-2"></i>Salvar Configurações</button>
                </div>

            </form>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
