<?php require 'views/layouts/header.php'; ?>
<?php $activePage = 'home_buttons'; ?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/admin_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2 class="h3 mb-0 text-gray-800">Editar Botão da Home</h2>
                <a href="<?php echo url('admin/home_buttons'); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Voltar
                </a>
            </div>

            <div class="card shadow mb-4">
                <div class="card-body">
                    <form action="<?php echo url('admin/edit_home_button/' . $button['id']); ?>" method="POST">
                        <div class="mb-3">
                            <label class="form-label">Texto do Botão</label>
                            <input type="text" name="text" class="form-control" value="<?php echo htmlspecialchars($button['text']); ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Classe do Ícone (FontAwesome)</label>
                            <input type="text" name="icon" class="form-control" value="<?php echo htmlspecialchars($button['icon']); ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Link de Destino</label>
                            <input type="text" name="link" class="form-control" value="<?php echo htmlspecialchars($button['link']); ?>" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Classe de Cor (Bootstrap)</label>
                            <select name="color_class" class="form-select">
                                <option value="btn-outline-primary" <?php echo $button['color_class'] == 'btn-outline-primary' ? 'selected' : ''; ?>>Primary (Azul)</option>
                                <option value="btn-outline-secondary" <?php echo $button['color_class'] == 'btn-outline-secondary' ? 'selected' : ''; ?>>Secondary (Cinza)</option>
                                <option value="btn-outline-success" <?php echo $button['color_class'] == 'btn-outline-success' ? 'selected' : ''; ?>>Success (Verde)</option>
                                <option value="btn-outline-danger" <?php echo $button['color_class'] == 'btn-outline-danger' ? 'selected' : ''; ?>>Danger (Vermelho)</option>
                                <option value="btn-outline-warning" <?php echo $button['color_class'] == 'btn-outline-warning' ? 'selected' : ''; ?>>Warning (Amarelo)</option>
                                <option value="btn-outline-info" <?php echo $button['color_class'] == 'btn-outline-info' ? 'selected' : ''; ?>>Info (Ciano)</option>
                                <option value="btn-outline-dark" <?php echo $button['color_class'] == 'btn-outline-dark' ? 'selected' : ''; ?>>Dark (Preto)</option>
                                <option value="btn-primary" <?php echo $button['color_class'] == 'btn-primary' ? 'selected' : ''; ?>>Sólido Primary</option>
                                <option value="btn-success" <?php echo $button['color_class'] == 'btn-success' ? 'selected' : ''; ?>>Sólido Success</option>
                                <option value="btn-warning" <?php echo $button['color_class'] == 'btn-warning' ? 'selected' : ''; ?>>Sólido Warning</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Ordem de Exibição</label>
                            <input type="number" name="sort_order" class="form-control" value="<?php echo $button['sort_order']; ?>">
                        </div>

                        <div class="mb-3 form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="active" name="active" value="1" <?php echo $button['active'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="active">Ativo</label>
                        </div>

                        <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>