<?php require 'views/layouts/header.php'; ?>
<?php $activePage = 'home_buttons'; ?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/admin_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2 class="h3 mb-0 text-gray-800">Novo Botão da Home</h2>
                <a href="<?php echo url('admin/home_buttons'); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Voltar
                </a>
            </div>

            <div class="card shadow mb-4">
                <div class="card-body">
                    <form action="<?php echo url('admin/create_home_button'); ?>" method="POST">
                        <div class="mb-3">
                            <label class="form-label">Texto do Botão</label>
                            <input type="text" name="text" class="form-control" required placeholder="Ex: Curso de Inglês">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Classe do Ícone (FontAwesome)</label>
                            <input type="text" name="icon" class="form-control" required placeholder="Ex: fas fa-star">
                            <div class="form-text">Use classes do FontAwesome 5 (ex: fas fa-home, fas fa-book).</div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Link de Destino</label>
                            <input type="text" name="link" class="form-control" required placeholder="Ex: courses ou http://google.com">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Classe de Cor (Bootstrap)</label>
                            <select name="color_class" class="form-select">
                                <option value="btn-outline-primary">Primary (Azul)</option>
                                <option value="btn-outline-secondary">Secondary (Cinza)</option>
                                <option value="btn-outline-success">Success (Verde)</option>
                                <option value="btn-outline-danger">Danger (Vermelho)</option>
                                <option value="btn-outline-warning">Warning (Amarelo)</option>
                                <option value="btn-outline-info">Info (Ciano)</option>
                                <option value="btn-outline-dark">Dark (Preto)</option>
                                <option value="btn-primary">Sólido Primary</option>
                                <option value="btn-success">Sólido Success</option>
                                <option value="btn-warning">Sólido Warning</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Ordem de Exibição</label>
                            <input type="number" name="sort_order" class="form-control" value="0">
                        </div>

                        <div class="mb-3 form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="active" name="active" value="1" checked>
                            <label class="form-check-label" for="active">Ativo</label>
                        </div>

                        <button type="submit" class="btn btn-primary">Salvar Botão</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>