<?php require 'views/layouts/header.php'; ?>

<div class="container mt-4">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo url('admin/courses'); ?>">Cursos</a></li>
            <li class="breadcrumb-item active" aria-current="page">Editar Curso</li>
        </ol>
    </nav>

    <h2>Editar Curso</h2>
    
    <div class="card mt-3">
        <div class="card-body">
            <form action="<?php echo url('admin/edit_course/' . $course['id']); ?>" method="POST" enctype="multipart/form-data">
                <div class="mb-3">
                    <label class="form-label">Título do Curso</label>
                    <input type="text" name="title" class="form-control" value="<?php echo $course['title']; ?>" required>
                </div>
                
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Categoria</label>
                        <select name="category_id" class="form-select" required>
                            <option value="">Selecione...</option>
                            <?php foreach($categories as $cat): ?>
                                <option value="<?php echo $cat['id']; ?>" <?php echo $course['category_id'] == $cat['id'] ? 'selected' : ''; ?>><?php echo $cat['name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Professor</label>
                        <select name="teacher_id" class="form-select" required>
                            <?php foreach($teachers as $teacher): ?>
                                <option value="<?php echo $teacher['id']; ?>" <?php echo $course['teacher_id'] == $teacher['id'] ? 'selected' : ''; ?>><?php echo $teacher['name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select" required>
                            <option value="draft" <?php echo $course['status'] == 'draft' ? 'selected' : ''; ?>>Rascunho</option>
                            <option value="published" <?php echo $course['status'] == 'published' ? 'selected' : ''; ?>>Publicado</option>
                            <option value="archived" <?php echo $course['status'] == 'archived' ? 'selected' : ''; ?>>Arquivado</option>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Preço (R$)</label>
                        <input type="number" name="price" class="form-control" step="0.01" min="0" value="<?php echo $course['price']; ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Duração</label>
                        <input type="text" name="duration" class="form-control" value="<?php echo isset($course['duration']) ? $course['duration'] : ''; ?>" placeholder="Ex: 20 Horas">
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Imagem de Capa</label>
                    <?php if($course['image']): ?>
                        <div class="mb-2">
                            <img src="<?php echo asset('uploads/' . $course['image']); ?>" alt="Atual" style="height: 100px;">
                        </div>
                    <?php endif; ?>
                    <input type="file" name="image" class="form-control" accept="image/*">
                </div>

                <div class="mb-3">
                    <label class="form-label">Descrição</label>
                    <textarea name="description" class="form-control" rows="5"><?php echo $course['description']; ?></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">O que vou aprender?</label>
                    <textarea name="what_will_i_learn" class="form-control" rows="4"><?php echo isset($course['what_will_i_learn']) ? $course['what_will_i_learn'] : ''; ?></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">Público-alvo</label>
                    <textarea name="target_audience" class="form-control" rows="3"><?php echo isset($course['target_audience']) ? $course['target_audience'] : ''; ?></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">Requisitos</label>
                    <textarea name="requirements" class="form-control" rows="3"><?php echo isset($course['requirements']) ? $course['requirements'] : ''; ?></textarea>
                </div>

                <button type="submit" class="btn btn-primary">Salvar Alterações</button>
            </form>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
