<?php require 'views/layouts/header.php'; ?>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4>Adicionar Novo Curso</h4>
            </div>
            <div class="card-body">
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <form action="<?php echo url('admin/create_course'); ?>" method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label class="form-label">Título do Curso</label>
                        <input type="text" name="title" class="form-control" required>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Categoria</label>
                            <select name="category_id" class="form-select">
                                <option value="">Selecione...</option>
                                <?php foreach($categories as $cat): ?>
                                    <option value="<?php echo $cat['id']; ?>"><?php echo $cat['name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Professor Responsável</label>
                            <select name="teacher_id" class="form-select" required>
                                <option value="">Selecione...</option>
                                <?php foreach($professors as $prof): ?>
                                    <option value="<?php echo $prof['id']; ?>"><?php echo $prof['name']; ?> (<?php echo ucfirst($prof['role']); ?>)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Preço (R$)</label>
                            <input type="number" step="0.01" name="price" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Duração (Ex: 130 à 180 Horas)</label>
                            <input type="text" name="duration" class="form-control" placeholder="Ex: 20 Horas">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Descrição</label>
                        <textarea name="description" class="form-control" rows="5"></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">O que vou aprender?</label>
                        <textarea name="what_will_i_learn" class="form-control" rows="4" placeholder="Liste os principais tópicos e habilidades que o aluno irá desenvolver."></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Público-alvo</label>
                        <textarea name="target_audience" class="form-control" rows="3" placeholder="Para quem é este curso? Ex: Iniciantes em programação, Profissionais de marketing, etc."></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Requisitos</label>
                        <textarea name="requirements" class="form-control" rows="3" placeholder="O que é necessário saber ou ter antes de começar? Ex: Conhecimento básico de inglês, Computador com acesso à internet."></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Imagem de Capa</label>
                        <input type="file" name="image" class="form-control">
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary">Salvar Curso</button>
                        <a href="<?php echo url('admin/courses'); ?>" class="btn btn-secondary">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
