<?php require 'views/layouts/header.php'; ?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="<?php echo url('admin/dashboard'); ?>" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="<?php echo url('admin/users'); ?>" class="list-group-item list-group-item-action">Usuários</a>
            <a href="<?php echo url('admin/courses'); ?>" class="list-group-item list-group-item-action active">Cursos</a>
            <a href="<?php echo url('admin/categories'); ?>" class="list-group-item list-group-item-action">Categorias</a>
            <a href="<?php echo url('admin/reports'); ?>" class="list-group-item list-group-item-action">Relatórios</a>
        </div>
    </div>
    <div class="col-md-9">
        <div class="d-flex justify-content-between align-items-center">
            <h2>Gerenciar Cursos</h2>
            <a href="<?php echo url('admin/create_course'); ?>" class="btn btn-success"><i class="fas fa-plus"></i> Novo Curso</a>
        </div>
        <div class="table-responsive">
            <table class="table table-striped mt-3">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Título</th>
                        <th>Professor</th>
                        <th>Categoria</th>
                        <th>Preço</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (isset($courses) && count($courses) > 0): ?>
                        <?php foreach ($courses as $c): ?>
                        <tr>
                            <td><?php echo $c['id']; ?></td>
                            <td><?php echo $c['title']; ?></td>
                            <td><?php echo $c['teacher_name']; ?></td>
                            <td><?php echo $c['category_name']; ?></td>
                            <td>R$ <?php echo number_format($c['price'], 2, ',', '.'); ?></td>
                            <td>
                                <?php 
                                $badgeClass = match($c['status']) {
                                    'published' => 'bg-success',
                                    'draft' => 'bg-warning text-dark',
                                    'archived' => 'bg-secondary',
                                    default => 'bg-secondary'
                                };
                                ?>
                                <span class="badge <?php echo $badgeClass; ?>"><?php echo ucfirst($c['status']); ?></span>
                            </td>
                            <td>
                                <a href="<?php echo url('admin/course_tutors/' . $c['id']); ?>" class="btn btn-sm btn-info text-white" title="Gerenciar Tutores"><i class="fas fa-chalkboard-teacher"></i></a>
                                <a href="<?php echo url('admin/edit_course/' . $c['id']); ?>" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a>
                                <a href="<?php echo url('professor/modules/' . $c['id']); ?>" class="btn btn-sm btn-info text-white" title="Gerenciar Conteúdo"><i class="fas fa-layer-group"></i></a>
                                <a href="<?php echo url('admin/delete_course/' . $c['id']); ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza? Isso apagará todos os módulos e aulas!')"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" class="text-center">Nenhum curso encontrado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
