<?php
require_once 'config/db.php';

try {
    // Create menu_items table
    $pdo->exec("CREATE TABLE IF NOT EXISTS menu_items (
        id INT AUTO_INCREMENT PRIMARY KEY,
        menu_location VARCHAR(50) NOT NULL,
        label VARCHAR(100) NOT NULL,
        link VARCHAR(255) NOT NULL,
        order_index INT DEFAULT 0,
        parent_id INT DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");

    // Insert default settings if not exist
    $defaultSettings = [
        'home_hero_title' => 'Matricule-se e escolha seus cursos na Sala Virtual!',
        'home_hero_subtext' => 'Você poderá estudar quantos cursos desejar.',
        'home_hero_btn_text' => 'MATRICULE-SE AGORA',
        'home_hero_btn_link' => '#cursos',
        'home_cert_title' => 'Os Certificados são válidos para:',
        'home_cert_items' => "Licença Capacitação\nTítulo em Concurso Público e Processos Seletivos\nContagem de Carga Horária para Estágio\nTitularidade para Professores\nAscensão de Carreira ou Cargo",
        'contact_phone' => '11 2364.6184',
        'contact_email' => 'contato@cursosonline.com.br',
        'social_facebook' => '#',
        'social_instagram' => '#',
        'social_linkedin' => '#',
        'stat_courses_count' => '2.362',
        'stat_students_count' => '112.126',
        'stat_certificates_count' => '118.092',
        'stat_courses_label' => 'Cursos Disponíveis',
        'stat_students_label' => 'Estudantes Matriculados',
        'stat_certificates_label' => 'Certificados Emitidos'
    ];

    $stmt = $pdo->prepare("SELECT id FROM settings WHERE key_name = ?");
    $insert = $pdo->prepare("INSERT INTO settings (key_name, value) VALUES (?, ?)");

    foreach ($defaultSettings as $key => $value) {
        $stmt->execute([$key]);
        if (!$stmt->fetch()) {
            $insert->execute([$key, $value]);
        }
    }

    echo "Database updated successfully.";
} catch (PDOException $e) {
    echo "Error updating database: " . $e->getMessage();
}
?>