<?php
require 'config/db.php';

echo "Atualizando tabela de matrículas para suporte a certificados...\n";

// Adicionar coluna certificate_code se não existir
try {
    $pdo->query("SELECT certificate_code FROM enrollments LIMIT 1");
    echo "Coluna certificate_code já existe.\n";
} catch (Exception $e) {
    $pdo->exec("ALTER TABLE enrollments ADD COLUMN certificate_code VARCHAR(50) UNIQUE DEFAULT NULL");
    echo "Coluna certificate_code adicionada.\n";
}

// Gerar códigos para matrículas concluídas que não têm código
$stmt = $pdo->query("SELECT id FROM enrollments WHERE completed = 1 AND certificate_code IS NULL");
$enrollments = $stmt->fetchAll();

foreach ($enrollments as $enrollment) {
    // Gerar código único: ANO-RANDOM-ID
    $code = date('Y') . '-' . strtoupper(substr(md5(uniqid()), 0, 8)) . '-' . $enrollment['id'];
    
    $update = $pdo->prepare("UPDATE enrollments SET certificate_code = ? WHERE id = ?");
    $update->execute([$code, $enrollment['id']]);
    echo "Código gerado para matrícula {$enrollment['id']}: $code\n";
}

echo "Concluído.\n";
