<?php
require_once 'config/config.php';
require_once 'config/db.php';

// Autoload simples para carregar classes
spl_autoload_register(function ($class_name) {
    if (file_exists('controllers/' . $class_name . '.php')) {
        require_once 'controllers/' . $class_name . '.php';
    } elseif (file_exists('models/' . $class_name . '.php')) {
        require_once 'models/' . $class_name . '.php';
    } elseif (file_exists('services/' . $class_name . '.php')) {
        require_once 'services/' . $class_name . '.php';
    }
});

// Roteamento Básico
$url = isset($_GET['url']) ? $_GET['url'] : 'home';
$urlParts = explode('/', rtrim($url, '/'));

// Normalizar controller name
$route = $urlParts[0];
$controllerName = 'HomeController';
$actionName = 'index';
$params = [];

// Mapeamento de rotas específicas
if (!empty($route)) {
    switch ($route) {
        case 'admin':
            $controllerName = 'AdminController';
            $actionName = isset($urlParts[1]) ? $urlParts[1] : 'dashboard';
            $params = array_slice($urlParts, 2);
            break;
        case 'professor':
            $controllerName = 'ProfessorController';
            $actionName = isset($urlParts[1]) ? $urlParts[1] : 'dashboard';
            $params = array_slice($urlParts, 2);
            break;
        case 'tutor':
            $controllerName = 'TutorController';
            $actionName = isset($urlParts[1]) ? $urlParts[1] : 'dashboard';
            $params = array_slice($urlParts, 2);
            break;
        case 'student':
            $controllerName = 'StudentController';
            // Actions: dashboard, classroom, certificate, history, save_review, get_comments, save_comment
            $actionName = isset($urlParts[1]) ? $urlParts[1] : 'dashboard';
            $params = array_slice($urlParts, 2);
            break;
        case 'login':
            $controllerName = 'AuthController';
            $actionName = 'login';
            break;
        case 'register':
            $controllerName = 'AuthController';
            $actionName = 'register';
            break;
        case 'logout':
            $controllerName = 'AuthController';
            $actionName = 'logout';
            break;
        case 'courses': // Mapeia 'courses' para 'CourseController'
            $controllerName = 'CourseController';
            $actionName = isset($urlParts[1]) ? $urlParts[1] : 'index';
            $params = array_slice($urlParts, 2);
            break;
        case 'course': // Mantém 'course' funcionando também
            $controllerName = 'CourseController';
            $actionName = isset($urlParts[1]) ? $urlParts[1] : 'index';
            
            // Fix for random requests like /course/excel-123...
            if (strpos($actionName, 'excel-') === 0) {
                 // Redirect to courses list
                 header("Location: /cursosonline/courses");
                 exit;
            }
            
            $params = array_slice($urlParts, 2);
            break;
        case 'validate_certificate':
            $controllerName = 'HomeController';
            $actionName = 'validate_certificate';
            break;
        default:
            // Rotas genéricas: controller/action/id
            // Tenta converter "meu-controller" para "MeuController"
            $controllerName = str_replace('-', '', ucwords($route, '-')) . 'Controller';
            $actionName = isset($urlParts[1]) ? $urlParts[1] : 'index';
            $params = array_slice($urlParts, 2);
            break;
    }
}

// Verifica se o arquivo do controller existe
if (file_exists('controllers/' . $controllerName . '.php')) {
    $controller = new $controllerName();
    if (method_exists($controller, $actionName)) {
        call_user_func_array([$controller, $actionName], $params);
    } else {
        // Se o método não existir, tenta o index passando o action como parametro (opcional, mas comum)
        // Por enquanto, erro 404
        echo "Erro 404: Método '$actionName' não encontrado no controller '$controllerName'.";
    }
} else {
    // Fallback para HomeController se a rota não bater com nenhum arquivo físico de controller
    if ($route == 'home') {
        $controller = new HomeController();
        $controller->index();
    } else {
        echo "Erro 404: Controller '$controllerName' não encontrado.";
    }
}
