<?php
class TutorController {
    public function __construct() {
        if (!isLoggedIn() || $_SESSION['user_role'] != 'tutor') {
            redirect('login');
        }
    }

    public function dashboard() {
        global $pdo;
        $userId = $_SESSION['user_id'];

        // Cursos vinculados
        $courses = $pdo->query("
            SELECT c.*, 
            (SELECT COUNT(*) FROM enrollments e WHERE e.course_id = c.id) as total_students,
            (SELECT COUNT(*) FROM comments cm 
             JOIN lessons l ON cm.lesson_id = l.id 
             JOIN modules m ON l.module_id = m.id 
             WHERE m.course_id = c.id AND cm.parent_id IS NULL) as total_questions
            FROM courses c 
            JOIN course_tutors ct ON c.id = ct.course_id 
            WHERE ct.user_id = $userId
        ")->fetchAll();

        require 'views/tutor/dashboard.php';
    }

    public function course($id) {
        global $pdo;
        $userId = $_SESSION['user_id'];

        // Verificar vínculo
        $check = $pdo->prepare("SELECT * FROM course_tutors WHERE course_id = :cid AND user_id = :uid");
        $check->execute(['cid' => $id, 'uid' => $userId]);
        if ($check->rowCount() == 0) redirect('tutor/dashboard');

        $courseModel = new Course();
        $course = $courseModel->getById($id);
        $modules = $courseModel->getModules($id);

        foreach ($modules as &$mod) {
            $stmt = $pdo->prepare("SELECT * FROM lessons WHERE module_id = :mid ORDER BY position ASC");
            $stmt->execute(['mid' => $mod['id']]);
            $mod['lessons'] = $stmt->fetchAll();
        }

        require 'views/tutor/course.php';
    }

    public function students($courseId) {
        global $pdo;
        $userId = $_SESSION['user_id'];
        
        // Verificar vínculo
        $check = $pdo->prepare("SELECT * FROM course_tutors WHERE course_id = :cid AND user_id = :uid");
        $check->execute(['cid' => $courseId, 'uid' => $userId]);
        if ($check->rowCount() == 0) redirect('tutor/dashboard');

        $stmt = $pdo->prepare("
            SELECT u.id, u.name, u.email, o.created_at as enrolled_at,
            (SELECT COUNT(*) FROM lesson_progress lp 
             JOIN lessons l ON lp.lesson_id = l.id 
             JOIN modules m ON l.module_id = m.id 
             WHERE m.course_id = :cid AND lp.user_id = u.id AND lp.completed = 1) as completed_lessons,
            (SELECT COUNT(*) FROM lessons l 
             JOIN modules m ON l.module_id = m.id 
             WHERE m.course_id = :cid) as total_lessons
            FROM orders o 
            JOIN users u ON o.user_id = u.id 
            WHERE o.course_id = :cid AND o.status = 'approved'
        ");
        $stmt->execute(['cid' => $courseId]);
        $students = $stmt->fetchAll();

        // Calcular %
        foreach ($students as &$student) {
            $student['progress'] = $student['total_lessons'] > 0 ? round(($student['completed_lessons'] / $student['total_lessons']) * 100) : 0;
        }

        require 'views/tutor/students.php';
    }

    public function comments() {
        global $pdo;
        $userId = $_SESSION['user_id'];

        // Comentários/Dúvidas dos cursos vinculados
        $comments = $pdo->query("
            SELECT cm.*, u.name as user_name, l.title as lesson_title, c.title as course_title 
            FROM comments cm
            JOIN users u ON cm.user_id = u.id
            JOIN lessons l ON cm.lesson_id = l.id
            JOIN modules m ON l.module_id = m.id
            JOIN courses c ON m.course_id = c.id
            JOIN course_tutors ct ON c.id = ct.course_id
            WHERE ct.user_id = $userId AND cm.parent_id IS NULL
            ORDER BY cm.created_at DESC
        ")->fetchAll();

        require 'views/tutor/comments.php';
    }

    public function reply_comment() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            global $pdo;
            $userId = $_SESSION['user_id'];
            $commentId = $_POST['comment_id'];
            $content = $_POST['content'];
            $lessonId = $_POST['lesson_id'];

            // Inserir resposta
            $stmt = $pdo->prepare("INSERT INTO comments (user_id, lesson_id, content, parent_id) VALUES (:uid, :lid, :content, :pid)");
            $stmt->execute([
                'uid' => $userId,
                'lid' => $lessonId,
                'content' => $content,
                'pid' => $commentId
            ]);

            redirect('tutor/comments');
        }
    }
}
