<?php
class HomeController {
    public function index() {
        global $pdo;
        
        // Buscar todas as categorias
        $stmt = $pdo->query("SELECT * FROM categories ORDER BY name ASC");
        $categories = $stmt->fetchAll();

        // Buscar cursos com contagem de alunos e nome da categoria para a home page
        $sql = "
            SELECT c.*, cat.name as category_name, cat.slug as category_slug, 
                   COUNT(e.id) as students_count
            FROM courses c
            LEFT JOIN categories cat ON c.category_id = cat.id
            LEFT JOIN enrollments e ON c.id = e.course_id
            WHERE c.status = 'published'
            GROUP BY c.id
            ORDER BY students_count DESC, c.created_at DESC
        ";

        $stmt = $pdo->query($sql);
        $courses = $stmt->fetchAll();
        
        // Número fictício de pessoas estudando (para o banner)
        $peopleStudying = rand(80, 150);

        require 'views/home/index.php';
    }

    public function validate_certificate() {
        global $pdo;
        $result = null;
        $error = null;

        if (isset($_GET['code'])) {
            $code = trim($_GET['code']);
            
            // Corrigido: usando c.duration em vez de c.hours
            $stmt = $pdo->prepare("
                SELECT e.*, u.name as student_name, c.title as course_title, c.duration as course_hours, 
                       COALESCE(e.updated_at, e.created_at) as completion_date
                FROM enrollments e
                JOIN users u ON e.user_id = u.id
                JOIN courses c ON e.course_id = c.id
                WHERE e.certificate_code = :code AND e.completed = 1
            ");
            $stmt->execute(['code' => $code]);
            $result = $stmt->fetch();

            if (!$result) {
                $error = "Certificado não encontrado ou inválido.";
            }
        }

        require 'views/home/validate_certificate.php';
    }
}
