<?php
class AuthController {
    public function login() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $email = $_POST['email'];
            $password = $_POST['password'];

            $userModel = new User();
            $user = $userModel->login($email, $password);

            if ($user) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['user_role'] = $user['role'];

                // Redirecionar baseado no papel
                if ($user['role'] === 'admin') {
                    redirect('admin/dashboard');
                } elseif ($user['role'] === 'professor') {
                    redirect('professor/dashboard');
                } else {
                    redirect('student/dashboard');
                }
            } else {
                $error = "Email ou senha inválidos.";
                require 'views/auth/login.php';
            }
        } else {
            require 'views/auth/login.php';
        }
    }

    public function register() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $name = $_POST['name'];
            $email = $_POST['email'];
            $password = $_POST['password'];
            $role = isset($_POST['role']) ? $_POST['role'] : 'student'; // Por segurança, talvez limitar roles no registro público

            // Validar se role é permitido no registro público (apenas student e talvez professor com aprovação, aqui deixarei student por padrão)
            if ($role != 'student' && $role != 'professor') {
                $role = 'student';
            }

            $userModel = new User();
            if ($userModel->register($name, $email, $password, $role)) {
                $success = "Cadastro realizado com sucesso! Faça login.";
                require 'views/auth/login.php';
            } else {
                $error = "Erro ao cadastrar. Email já pode estar em uso.";
                require 'views/auth/register.php';
            }
        } else {
            require 'views/auth/register.php';
        }
    }

    public function logout() {
        session_destroy();
        redirect('login');
    }
}
