<?php
// Detecção automática da URL base
$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$script = $_SERVER['SCRIPT_NAME'];
$path = dirname($script);

// Normalizar barras no Windows
$path = str_replace('\\', '/', $path);

// Ajuste para quando rodar na raiz (ex: php -S) ou subpasta
// Se path for apenas "/", remove para evitar duplicidade na concatenação posterior
if ($path == '/') {
    $path = '';
}

$baseUrl = $protocol . "://" . $host . $path;

// Garante que termina com barra
if (substr($baseUrl, -1) !== '/') {
    $baseUrl .= '/';
}

define('BASE_URL', $baseUrl);
define('SITE_NAME', 'Plataforma EAD');

// Iniciar sessão
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Função para url amigável
function url($path = '') {
    return BASE_URL . ltrim($path, '/');
}

// Função para redirecionar
function redirect($path) {
    header("Location: " . url($path));
    exit;
}

// Função para verificar se está logado
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Função para verificar permissão
function hasRole($role) {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === $role;
}

// Função helper para assets
function asset($path) {
    return BASE_URL . 'assets/' . ltrim($path, '/');
}

// Helper para obter configurações
function get_setting($key) {
    global $pdo;
    if (!isset($pdo)) return null;
    
    // Cache simples em memória para evitar queries repetidas na mesma requisição
    static $settings_cache = [];
    if (isset($settings_cache[$key])) return $settings_cache[$key];

    $stmt = $pdo->prepare("SELECT value FROM settings WHERE key_name = ?");
    $stmt->execute([$key]);
    $value = $stmt->fetchColumn();
    
    $settings_cache[$key] = $value;
    return $value;
}

// Helper para obter anúncios
function get_ads($location) {
    global $pdo;
    if (!isset($pdo)) return [];
    $stmt = $pdo->prepare("SELECT * FROM ads WHERE location = ? AND active = 1 ORDER BY RAND()");
    $stmt->execute([$location]);
    return $stmt->fetchAll();
}

// Helper para obter categorias
function get_categories_helper() {
    global $pdo;
    if (!isset($pdo)) return [];
    try {
        $stmt = $pdo->query("SELECT * FROM categories ORDER BY name ASC");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        return [];
    }
}

// Helper para obter botões da home
function get_home_buttons() {
    global $pdo;
    if (!isset($pdo)) return [];
    $stmt = $pdo->prepare("SELECT * FROM home_buttons WHERE active = 1 ORDER BY sort_order ASC");
    $stmt->execute();
    return $stmt->fetchAll();
}

function get_menu($location) {
    global $pdo;
    if (!isset($pdo)) return [];
    $stmt = $pdo->prepare("SELECT * FROM menu_items WHERE menu_location = ? ORDER BY order_index ASC");
    $stmt->execute([$location]);
    return $stmt->fetchAll();
}
