<?php require 'views/layouts/header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <?php 
        $activePage = 'dashboard';
        require 'views/layouts/tutor_sidebar.php'; 
        ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Alunos - <?php echo $course['title'] ?? 'Curso'; ?></h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <a href="<?php echo url('tutor/dashboard'); ?>" class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Voltar
                    </a>
                </div>
            </div>

            <div class="card border-0 shadow-sm">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="ps-4">Nome</th>
                                    <th>Email</th>
                                    <th>Matriculado em</th>
                                    <th>Progresso</th>
                                    <th class="text-end pe-4">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($students as $student): ?>
                                <tr>
                                    <td class="ps-4 fw-bold text-dark"><?php echo $student['name']; ?></td>
                                    <td><?php echo $student['email']; ?></td>
                                    <td><?php echo date('d/m/Y', strtotime($student['enrolled_at'])); ?></td>
                                    <td style="width: 20%;">
                                        <div class="d-flex align-items-center">
                                            <div class="progress flex-grow-1 me-2" style="height: 6px;">
                                                <div class="progress-bar <?php echo $student['progress'] == 100 ? 'bg-success' : 'bg-primary'; ?>" 
                                                     role="progressbar" 
                                                     style="width: <?php echo $student['progress']; ?>%;" 
                                                     aria-valuenow="<?php echo $student['progress']; ?>" 
                                                     aria-valuemin="0" 
                                                     aria-valuemax="100"></div>
                                            </div>
                                            <span class="small fw-bold"><?php echo $student['progress']; ?>%</span>
                                        </div>
                                    </td>
                                    <td class="text-end pe-4">
                                        <button class="btn btn-sm btn-outline-primary" onclick="alert('Funcionalidade de mensagem direta em breve!')">
                                            <i class="fas fa-envelope me-1"></i> Mensagem
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php if(empty($students)): ?>
                                    <tr>
                                        <td colspan="5" class="text-center py-5 text-muted">
                                            <i class="fas fa-user-slash fa-2x mb-3 opacity-50"></i>
                                            <p class="mb-0">Nenhum aluno matriculado neste curso.</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
