<?php require 'views/layouts/header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <?php 
        $activePage = 'dashboard';
        require 'views/layouts/tutor_sidebar.php'; 
        ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Conteúdo: <?php echo $course['title']; ?></h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <a href="<?php echo url('tutor/dashboard'); ?>" class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Voltar
                    </a>
                </div>
            </div>

            <div class="accordion accordion-flush" id="accordionModules">
                <?php foreach($modules as $index => $module): ?>
                <div class="accordion-item border rounded mb-3 overflow-hidden shadow-sm">
                    <h2 class="accordion-header" id="heading<?php echo $module['id']; ?>">
                        <button class="accordion-button <?php echo $index > 0 ? 'collapsed' : ''; ?> bg-light fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $module['id']; ?>" aria-expanded="<?php echo $index === 0 ? 'true' : 'false'; ?>" aria-controls="collapse<?php echo $module['id']; ?>">
                            <?php echo $module['title']; ?>
                        </button>
                    </h2>
                    <div id="collapse<?php echo $module['id']; ?>" class="accordion-collapse collapse <?php echo $index === 0 ? 'show' : ''; ?>" aria-labelledby="heading<?php echo $module['id']; ?>" data-bs-parent="#accordionModules">
                        <div class="accordion-body p-0">
                            <ul class="list-group list-group-flush">
                                <?php foreach($module['lessons'] as $lesson): ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center py-3">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-primary bg-opacity-10 text-primary rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                            <i class="fas fa-<?php echo $lesson['type'] == 'video' ? 'play' : ($lesson['type'] == 'pdf' ? 'file-pdf' : 'file-alt'); ?>"></i>
                                        </div>
                                        <div>
                                            <h6 class="mb-0 fw-bold"><?php echo $lesson['title']; ?></h6>
                                            <small class="text-muted text-uppercase" style="font-size: 0.7rem;"><?php echo $lesson['type']; ?></small>
                                        </div>
                                    </div>
                                    <!-- Futuramente pode ter botão para ver a aula -->
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
                
                <?php if(empty($modules)): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i> Este curso ainda não possui módulos cadastrados.
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
