<?php require 'views/layouts/header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <?php 
        $activePage = 'comments';
        require 'views/layouts/tutor_sidebar.php'; 
        ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Moderação de Dúvidas</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <a href="<?php echo url('tutor/dashboard'); ?>" class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Voltar
                    </a>
                </div>
            </div>

            <div class="list-group list-group-flush border-0">
                <?php foreach($comments as $comment): ?>
                <div class="list-group-item border rounded-3 mb-3 shadow-sm p-4 bg-white">
                    <div class="d-flex w-100 justify-content-between align-items-center mb-3">
                        <div>
                            <h5 class="mb-1 fw-bold text-dark"><?php echo $comment['user_name']; ?></h5>
                            <small class="text-muted">
                                <i class="fas fa-book-open me-1"></i> <?php echo $comment['lesson_title']; ?> 
                                <span class="mx-2">•</span> 
                                <i class="fas fa-layer-group me-1"></i> <?php echo $comment['course_title']; ?>
                            </small>
                        </div>
                        <small class="text-muted bg-light px-2 py-1 rounded">
                            <?php echo date('d/m/Y H:i', strtotime($comment['created_at'])); ?>
                        </small>
                    </div>
                    
                    <p class="mb-3 text-secondary" style="font-size: 1.05rem;"><?php echo nl2br($comment['content']); ?></p>
                    
                    <!-- Respostas anteriores -->
                    <?php 
                        global $pdo;
                        $replies = $pdo->query("SELECT c.*, u.name FROM comments c JOIN users u ON c.user_id = u.id WHERE parent_id = {$comment['id']}")->fetchAll();
                        if($replies):
                    ?>
                        <div class="ms-4 mt-3 ps-3 border-start border-3 border-primary bg-light p-3 rounded">
                            <?php foreach($replies as $reply): ?>
                                <div class="mb-2">
                                    <strong class="text-primary"><?php echo $reply['name']; ?>:</strong> 
                                    <span class="text-dark"><?php echo nl2br($reply['content']); ?></span>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                    <!-- Formulário de Resposta -->
                    <form action="<?php echo url('tutor/reply_comment'); ?>" method="POST" class="mt-4">
                        <input type="hidden" name="comment_id" value="<?php echo $comment['id']; ?>">
                        <input type="hidden" name="lesson_id" value="<?php echo $comment['lesson_id']; ?>">
                        <div class="input-group">
                            <input type="text" name="content" class="form-control" placeholder="Escreva uma resposta..." required>
                            <button class="btn btn-primary px-4" type="submit">
                                <i class="fas fa-paper-plane me-2"></i> Responder
                            </button>
                        </div>
                    </form>
                </div>
                <?php endforeach; ?>
                
                <?php if(empty($comments)): ?>
                    <div class="text-center py-5">
                        <div class="d-inline-flex align-items-center justify-content-center bg-success bg-opacity-10 text-success rounded-circle mb-3" style="width: 80px; height: 80px;">
                            <i class="fas fa-check fa-3x"></i>
                        </div>
                        <h4 class="fw-bold text-dark">Tudo em dia!</h4>
                        <p class="text-muted">Nenhuma dúvida pendente de resposta.</p>
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
