<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Certificado de Conclusão - <?php echo $courseName; ?></title>
    <style>
        @page { size: landscape; margin: 0; }
        body { font-family: 'Times New Roman', serif; background: #fff; text-align: center; margin: 0; padding: 0; -webkit-print-color-adjust: exact; }
        .certificate-container {
            width: 100%; height: 100vh; display: flex; justify-content: center; align-items: center; background: #f9f9f9;
        }
        .certificate {
            width: 297mm; height: 210mm; background: white; padding: 40px;
            border: 20px solid #2c3e50; position: relative; box-sizing: border-box;
            background-image: radial-gradient(circle at center, #fff 50%, #f0f0f0 100%);
        }
        .border-inner {
            border: 5px solid #d4af37; height: 100%; width: 100%; position: relative; box-sizing: border-box; padding: 30px;
        }
        .logo { margin-bottom: 20px; font-size: 24px; font-weight: bold; color: #2c3e50; text-transform: uppercase; letter-spacing: 5px; }
        .header { font-size: 50px; font-weight: bold; color: #2c3e50; margin: 20px 0; font-family: 'Helvetica', sans-serif; text-transform: uppercase; }
        .sub-header { font-size: 24px; color: #7f8c8d; margin: 10px 0; }
        .name { font-size: 60px; color: #d4af37; margin: 30px 0; border-bottom: 2px solid #d4af37; display: inline-block; padding: 0 50px 10px; font-style: italic; font-weight: bold; }
        .course { font-size: 36px; font-weight: bold; color: #2c3e50; margin: 20px 0; }
        .date { font-size: 18px; color: #7f8c8d; position: absolute; bottom: 60px; left: 60px; text-align: left; }
        .signature { position: absolute; bottom: 60px; right: 60px; text-align: center; }
        .signature-line { width: 250px; border-top: 2px solid #2c3e50; margin-bottom: 10px; }
        .signature-text { font-size: 16px; color: #2c3e50; font-weight: bold; }
        .code { font-size: 12px; color: #95a5a6; position: absolute; bottom: 20px; left: 50%; transform: translateX(-50%); }
        .ribbon {
            position: absolute; top: 0; right: 0; width: 150px; height: 150px; overflow: hidden;
        }
        .ribbon-content {
            background: #d4af37; color: white; padding: 10px; text-align: center; transform: rotate(45deg); position: relative; top: 30px; left: 30px; width: 200px; box-shadow: 0 5px 10px rgba(0,0,0,0.2);
        }
        @media print {
            .certificate-container { background: white; height: auto; display: block; }
            .certificate { margin: 0; box-shadow: none; page-break-after: always; }
        }
    </style>
</head>
<body onload="window.print()">
    <div class="certificate-container">
        <div class="certificate">
            <div class="border-inner">
                <div class="logo"><i class="fas fa-graduation-cap"></i> Plataforma EAD</div>
                
                <div class="ribbon">
                    <div class="ribbon-content">Concluído</div>
                </div>

                <div class="header">Certificado</div>
                
                <div class="sub-header">Este documento certifica que</div>
                
                <div class="name"><?php echo $studentName; ?></div>
                
                <div class="sub-header">concluiu com êxito o curso de</div>
                
                <div class="course"><?php echo $courseName; ?></div>
                
                <div class="sub-header">com carga horária estimada de <?php echo $totalLessons * 20; ?> minutos.</div>
                
                <div class="date">
                    <strong>Data de Conclusão:</strong><br>
                    <?php echo $date; ?>
                </div>
                
                <div class="signature">
                    <div class="signature-line"></div>
                    <div class="signature-text">Direção Pedagógica</div>
                    <small>Cursos Online EAD</small>
                </div>

                <div class="code">
                    Código de Autenticidade: <?php echo $code; ?><br>
                    Verifique a validade deste certificado em nosso site.
                </div>
            </div>
        </div>
    </div>
</body>
</html>
