<?php require 'views/layouts/header.php'; ?>

<div class="container mt-4">
    <h2>Meus Alunos</h2>
    <p class="text-muted">Lista de alunos matriculados em seus cursos.</p>

    <?php if (count($students) > 0): ?>
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Nome</th>
                        <th>Email</th>
                        <th>Curso</th>
                        <th>Data de Matrícula</th>
                        <th>Progresso</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($students as $student): ?>
                        <tr>
                            <td><?php echo $student['name']; ?></td>
                            <td><?php echo $student['email']; ?></td>
                            <td><?php echo $student['course_title']; ?></td>
                            <td><?php echo date('d/m/Y', strtotime($student['enrolled_at'])); ?></td>
                            <td>
                                <div class="progress" style="height: 20px;">
                                    <div class="progress-bar bg-success" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0%</div>
                                </div>
                                <small class="text-muted">(Em breve)</small>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-info">Nenhum aluno matriculado ainda.</div>
    <?php endif; ?>
</div>

<?php require 'views/layouts/footer.php'; ?>
