<?php include 'views/layouts/header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <?php include 'views/layouts/professor_sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Gerenciar Perguntas: <?php echo htmlspecialchars($lesson['title']); ?></h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <a href="<?php echo url('professor/modules/' . $lesson['course_id']); ?>" class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-arrow-left"></i> Voltar
                    </a>
                </div>
            </div>

            <div class="row">
                <!-- Add Question Form -->
                <div class="col-md-5 mb-4">
                    <div class="card">
                        <div class="card-header bg-primary text-white">
                            Adicionar Nova Pergunta
                        </div>
                        <div class="card-body">
                            <form action="<?php echo url('professor/add_question'); ?>" method="POST">
                                <input type="hidden" name="quiz_id" value="<?php echo $lesson['quiz_id']; ?>">
                                <input type="hidden" name="lesson_id" value="<?php echo $lesson['id']; ?>">
                                
                                <div class="mb-3">
                                    <label class="form-label">Pergunta</label>
                                    <textarea name="question_text" class="form-control" rows="3" required></textarea>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Tipo</label>
                                        <select name="question_type" class="form-select" id="questionType" onchange="toggleOptions()">
                                            <option value="multiple_choice">Múltipla Escolha</option>
                                            <option value="text">Resposta Escrita</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Pontos</label>
                                        <input type="number" name="points" class="form-control" value="10" min="1">
                                    </div>
                                </div>

                                <div class="mb-3" id="options-wrapper">
                                    <label class="form-label">Opções de Resposta</label>
                                    <div id="options-container">
                                        <div class="input-group mb-2">
                                            <div class="input-group-text">
                                                <input class="form-check-input mt-0" type="radio" name="correct_option" value="0" checked aria-label="Correta">
                                            </div>
                                            <input type="text" name="options[]" class="form-control" placeholder="Opção 1" required>
                                        </div>
                                        <div class="input-group mb-2">
                                            <div class="input-group-text">
                                                <input class="form-check-input mt-0" type="radio" name="correct_option" value="1" aria-label="Correta">
                                            </div>
                                            <input type="text" name="options[]" class="form-control" placeholder="Opção 2" required>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="addOption()">
                                        <i class="fas fa-plus"></i> Adicionar Opção
                                    </button>
                                </div>

                                <button type="submit" class="btn btn-primary w-100">Salvar Pergunta</button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Questions List -->
                <div class="col-md-7">
                    <div class="card">
                        <div class="card-header">
                            Perguntas Cadastradas
                        </div>
                        <div class="card-body">
                            <?php if (empty($questions)): ?>
                                <p class="text-muted text-center my-4">Nenhuma pergunta cadastrada ainda.</p>
                            <?php else: ?>
                                <div class="accordion" id="questionsAccordion">
                                    <?php foreach ($questions as $index => $q): ?>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="heading<?php echo $q['id']; ?>">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $q['id']; ?>">
                                                    <span class="badge bg-secondary me-2"><?php echo $q['points']; ?> pts</span>
                                                    <strong><?php echo ($index + 1); ?>.</strong>&nbsp;
                                                    <?php 
                                                        $displayText = $q['question_text'];
                                                        if(strlen($displayText) > 50) $displayText = substr($displayText, 0, 50) . '...';
                                                        echo htmlspecialchars($displayText); 
                                                    ?>
                                                </button>
                                            </h2>
                                            <div id="collapse<?php echo $q['id']; ?>" class="accordion-collapse collapse" data-bs-parent="#questionsAccordion">
                                                <div class="accordion-body">
                                                    <p class="fw-bold">
                                                        <span class="text-muted">Questão <?php echo ($index + 1); ?>:</span><br>
                                                        <?php echo nl2br(htmlspecialchars($q['question_text'])); ?>
                                                    </p>
                                                    
                                                    <?php if($q['question_type'] == 'multiple_choice'): ?>
                                                        <ul class="list-group mb-3">
                                                            <?php foreach ($q['options'] as $opt): ?>
                                                                <li class="list-group-item <?php echo $opt['is_correct'] ? 'list-group-item-success' : ''; ?>">
                                                                    <?php echo htmlspecialchars($opt['option_text']); ?>
                                                                    <?php if($opt['is_correct']): ?>
                                                                    <i class="fas fa-check float-end"></i>
                                                                <?php endif; ?>
                                                            </li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                    <?php elseif($q['question_type'] == 'text'): ?>
                                                        <div class="alert alert-info">
                                                            <i class="fas fa-pen-alt"></i> Esta pergunta requer uma resposta escrita do aluno.
                                                        </div>
                                                    <?php endif; ?>

                                                    <div class="text-end">
                                                        <a href="<?php echo url('professor/delete_question/' . $q['id']); ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza que deseja excluir esta pergunta?')">
                                                            <i class="fas fa-trash"></i> Excluir
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<script>
function toggleOptions() {
    const type = document.getElementById('questionType').value;
    const wrapper = document.getElementById('options-wrapper');
    const inputs = wrapper.querySelectorAll('input');
    
    if (type === 'text') {
        wrapper.style.display = 'none';
        inputs.forEach(input => {
            input.disabled = true;
            input.required = false;
        });
    } else {
        wrapper.style.display = 'block';
        inputs.forEach(input => {
            input.disabled = false;
            if(input.type === 'text') input.required = true;
        });
    }
}

let optionCount = 2;
function addOption() {
    const container = document.getElementById('options-container');
    const div = document.createElement('div');
    div.className = 'input-group mb-2';
    div.innerHTML = `
        <div class="input-group-text">
            <input class="form-check-input mt-0" type="radio" name="correct_option" value="${optionCount}" aria-label="Correta">
        </div>
        <input type="text" name="options[]" class="form-control" placeholder="Opção ${optionCount + 1}" required>
        <button class="btn btn-outline-danger" type="button" onclick="this.parentElement.remove()">
            <i class="fas fa-times"></i>
        </button>
    `;
    container.appendChild(div);
    optionCount++;
}
</script>

<?php include 'views/layouts/footer.php'; ?>