<?php require 'views/layouts/header.php'; ?>

<div class="container mt-4">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo url('professor/courses'); ?>">Meus Cursos</a></li>
            <li class="breadcrumb-item active" aria-current="page">Conteúdo: <?php echo $course['title']; ?></li>
        </ol>
    </nav>

    <h2>Gerenciar Conteúdo do Curso</h2>
    <p class="text-muted">
        Adicione módulos e aulas para estruturar seu curso. 
        <span class="badge bg-info text-dark ms-2">Duração Total: <?php echo $totalDuration; ?></span>
        <a href="<?php echo url('professor/sync_durations/' . $course['id']); ?>" class="btn btn-sm btn-outline-info ms-2" onclick="return confirm('Isso irá tentar buscar a duração de todos os vídeos do YouTube novamente. Pode levar alguns segundos. Continuar?')">
            <i class="fas fa-sync"></i> Sincronizar Durações
        </a>
    </p>

    <!-- Adicionar Módulo -->
    <div class="card mb-4 bg-light">
        <div class="card-body">
            <h5 class="card-title">Novo Módulo</h5>
            <form action="<?php echo url('professor/add_module'); ?>" method="POST" class="row g-3 align-items-center">
                <input type="hidden" name="course_id" value="<?php echo $course['id']; ?>">
                <div class="col-auto flex-grow-1">
                    <input type="text" name="title" class="form-control" placeholder="Nome do Módulo (ex: Introdução)" required>
                </div>
                <div class="col-auto">
                    <button type="submit" class="btn btn-success">Adicionar Módulo</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Lista de Módulos e Aulas -->
    <div class="accordion" id="accordionManager">
        <?php foreach ($modules as $index => $module): ?>
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading<?php echo $module['id']; ?>">
                <div class="d-flex align-items-center">
                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $module['id']; ?>">
                        <?php echo $module['title']; ?>
                    </button>
                    <div class="px-2 bg-white border-bottom border-start d-flex align-items-center" style="height: 52px;">
                         <button class="btn btn-sm btn-outline-warning me-1" onclick="openEditModule(<?php echo $module['id']; ?>, <?php echo htmlspecialchars(json_encode($module['title'])); ?>)" title="Editar Módulo">
                            <i class="fas fa-edit"></i>
                         </button>
                         <a href="<?php echo url('professor/delete_module/' . $module['id']); ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Tem certeza? Todas as aulas deste módulo serão apagadas!')" title="Excluir Módulo">
                            <i class="fas fa-trash"></i>
                         </a>
                    </div>
                </div>
            </h2>
            <div id="collapse<?php echo $module['id']; ?>" class="accordion-collapse collapse show">
                <div class="accordion-body">
                    
                    <!-- Lista de Aulas do Módulo -->
                    <ul class="list-group mb-3">
                        <?php foreach($module['lessons'] as $lesson): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <i class="fas fa-<?php echo $lesson['type'] == 'video' ? 'video' : ($lesson['type'] == 'pdf' ? 'file-pdf' : 'file-alt'); ?> text-muted me-2"></i>
                                    <?php echo $lesson['title']; ?>
                                    <?php if(!empty($lesson['duration'])): ?>
                                        <small class="text-muted ms-2">(<?php echo $lesson['duration']; ?>)</small>
                                    <?php endif; ?>
                                </div>
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-secondary rounded-pill me-2"><?php echo ucfirst($lesson['type']); ?></span>
                                    
                                    <div class="btn-group me-2" role="group">
                                        <a href="<?php echo url('professor/move_lesson/' . $lesson['id'] . '/up'); ?>" class="btn btn-sm btn-outline-secondary" title="Mover para Cima">
                                            <i class="fas fa-arrow-up"></i>
                                        </a>
                                        <a href="<?php echo url('professor/move_lesson/' . $lesson['id'] . '/down'); ?>" class="btn btn-sm btn-outline-secondary" title="Mover para Baixo">
                                            <i class="fas fa-arrow-down"></i>
                                        </a>
                                    </div>

                                    <?php if($lesson['type'] === 'quiz' || $lesson['type'] === 'exam'): ?>
                                        <a href="<?php echo url('professor/quiz_builder/' . $lesson['id']); ?>" class="btn btn-sm btn-primary me-1" title="Gerenciar Perguntas">
                                            <i class="fas fa-list-ol"></i> Perguntas
                                        </a>
                                    <?php endif; ?>

                                    <a href="<?php echo url('professor/duplicate_lesson/' . $lesson['id']); ?>" class="btn btn-sm btn-outline-info me-1" title="Duplicar Aula" onclick="return confirm('Deseja duplicar esta aula?')">
                                        <i class="fas fa-copy"></i>
                                    </a>

                                    <button class="btn btn-sm btn-outline-warning me-1" onclick="openEditLesson(<?php echo htmlspecialchars(json_encode($lesson), ENT_QUOTES, 'UTF-8'); ?>, <?php echo $course['id']; ?>)" title="Editar Aula">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <a href="<?php echo url('professor/delete_lesson/' . $lesson['id']); ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Tem certeza que deseja apagar esta aula?')" title="Excluir Aula">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </li>
                        <?php endforeach; ?>
                        <?php if(count($module['lessons']) == 0): ?>
                            <li class="list-group-item text-muted">Nenhuma aula neste módulo.</li>
                        <?php endif; ?>
                    </ul>

                    <!-- Botão para abrir modal de nova aula -->
                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="openAddLesson(<?php echo $module['id']; ?>, <?php echo htmlspecialchars(json_encode($module['title']), ENT_QUOTES, 'UTF-8'); ?>)">
                        <i class="fas fa-plus"></i> Adicionar Aula
                    </button>

                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- Edit Module Modal -->
<div class="modal fade" id="modalEditModule" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo url('professor/edit_module'); ?>" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Editar Módulo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="course_id" value="<?php echo $course['id']; ?>">
                    <input type="hidden" name="module_id" id="edit_module_id">
                    <div class="mb-3">
                        <label class="form-label">Nome do Módulo</label>
                        <input type="text" name="title" id="edit_module_title" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Lesson Modal -->
<div class="modal fade" id="modalEditLesson" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo url('professor/edit_lesson'); ?>" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Editar Aula</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="course_id" value="<?php echo $course['id']; ?>">
                    <input type="hidden" name="lesson_id" id="edit_lesson_id">
                    
                    <div class="mb-3">
                        <label class="form-label">Título da Aula</label>
                        <input type="text" name="title" id="edit_lesson_title" class="form-control" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Tipo</label>
                        <select name="type" class="form-select" id="edit_lesson_type" onchange="toggleEditLessonFields()">
                            <option value="video">Vídeo</option>
                            <option value="text">Texto</option>
                            <option value="pdf">PDF (Link)</option>
                            <option value="quiz">Quiz (Exercício)</option>
                            <option value="exam">Prova (Avaliação)</option>
                        </select>
                    </div>

                    <div class="mb-3" id="edit_field_video">
                        <label class="form-label">URL do Vídeo (YouTube/Vimeo)</label>
                        <input type="text" name="video_url" id="edit_lesson_video" class="form-control" placeholder="https://www.youtube.com/watch?v=...">
                    </div>

                    <div class="mb-3" id="edit_field_text" style="display:none;">
                        <label class="form-label">Conteúdo (Texto/HTML)</label>
                        <textarea name="content" id="edit_lesson_content" class="form-control" rows="5"></textarea>
                    </div>

                    <div class="mb-3" id="edit_field_quiz" style="display:none;">
                         <div class="row">
                            <div class="col-md-6 mb-2">
                                <label class="form-label">Tempo Limite (minutos)</label>
                                <input type="number" name="time_limit" id="edit_quiz_time" class="form-control" placeholder="0 = Sem limite" value="0">
                            </div>
                            <div class="col-md-6 mb-2">
                                <label class="form-label">Nota Mínima (%)</label>
                                <input type="number" name="passing_score" id="edit_quiz_score" class="form-control" placeholder="Ex: 70" value="70">
                            </div>
                        </div>
                        <div class="d-grid gap-2 mt-3">
                            <button type="submit" name="save_and_manage" value="1" id="btn_manage_questions" class="btn btn-outline-primary">
                                <i class="fas fa-list-ol"></i> Salvar e Gerenciar Perguntas
                            </button>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Lesson Modal -->
<div class="modal fade" id="modalAddLesson" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="<?php echo url('professor/add_lesson'); ?>" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalAddLessonTitle">Nova Aula</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="course_id" value="<?php echo $course['id']; ?>">
                    <input type="hidden" name="module_id" id="add_lesson_module_id">
                    
                    <div class="mb-3">
                        <label class="form-label">Título da Aula</label>
                        <input type="text" name="title" id="add_lesson_title" class="form-control" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Tipo</label>
                        <select name="type" class="form-select" id="add_lesson_type" onchange="toggleAddLessonFields()">
                            <option value="video">Vídeo</option>
                            <option value="text">Texto</option>
                            <option value="pdf">PDF (Link)</option>
                            <option value="quiz">Quiz (Exercício)</option>
                            <option value="exam">Prova (Avaliação)</option>
                        </select>
                    </div>

                    <div class="mb-3" id="add_field_video">
                        <label class="form-label">URL do Vídeo (YouTube/Vimeo)</label>
                        <input type="text" name="video_url" id="add_lesson_video" class="form-control" placeholder="https://www.youtube.com/watch?v=...">
                    </div>

                    <div class="mb-3" id="add_field_text" style="display:none;">
                        <label class="form-label">Conteúdo (Texto/HTML)</label>
                        <textarea name="content" id="add_lesson_content" class="form-control" rows="5"></textarea>
                    </div>

                    <div class="mb-3" id="add_field_quiz" style="display:none;">
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <label class="form-label">Tempo Limite (minutos)</label>
                                <input type="number" name="time_limit" id="add_quiz_time" class="form-control" placeholder="0 = Sem limite" value="0">
                            </div>
                            <div class="col-md-6 mb-2">
                                <label class="form-label">Nota Mínima (%)</label>
                                <input type="number" name="passing_score" id="add_quiz_score" class="form-control" placeholder="Ex: 70" value="70">
                            </div>
                        </div>
                        <p class="text-muted small">Você poderá adicionar as perguntas após salvar a aula.</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar Aula</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function openAddLesson(moduleId, moduleTitle) {
    document.getElementById('add_lesson_module_id').value = moduleId;
    document.getElementById('modalAddLessonTitle').innerText = 'Nova Aula em "' + moduleTitle + '"';
    
    // Reset fields
    document.getElementById('add_lesson_title').value = '';
    document.getElementById('add_lesson_type').value = 'video';
    document.getElementById('add_lesson_video').value = '';
    document.getElementById('add_lesson_content').value = '';
    document.getElementById('add_quiz_time').value = '0';
    document.getElementById('add_quiz_score').value = '70';
    
    toggleAddLessonFields();
    
    var modal = new bootstrap.Modal(document.getElementById('modalAddLesson'));
    modal.show();
}

function toggleAddLessonFields() {
    const type = document.getElementById('add_lesson_type').value;
    const fieldVideo = document.getElementById('add_field_video');
    const fieldText = document.getElementById('add_field_text');
    const fieldQuiz = document.getElementById('add_field_quiz');

    // Reset
    fieldVideo.style.display = 'none';
    fieldText.style.display = 'none';
    if(fieldQuiz) fieldQuiz.style.display = 'none';

    if (type === 'video') {
        fieldVideo.style.display = 'block';
    } else if (type === 'text' || type === 'pdf') {
        fieldText.style.display = 'block';
    } else if (type === 'quiz' || type === 'exam') {
        if(fieldQuiz) fieldQuiz.style.display = 'block';
    }
}

function openEditModule(id, title) {
    document.getElementById('edit_module_id').value = id;
    document.getElementById('edit_module_title').value = title;
    var modal = new bootstrap.Modal(document.getElementById('modalEditModule'));
    modal.show();
}

function openEditLesson(lesson, courseId) {
    document.getElementById('edit_lesson_id').value = lesson.id;
    document.getElementById('edit_lesson_title').value = lesson.title;
    document.getElementById('edit_lesson_type').value = lesson.type;
    document.getElementById('edit_lesson_video').value = lesson.video_url || '';
    document.getElementById('edit_lesson_content').value = lesson.content || '';
    
    toggleEditLessonFields();

    if(lesson.type === 'quiz' || lesson.type === 'exam') {
        document.getElementById('edit_quiz_time').value = lesson.time_limit || 0;
        document.getElementById('edit_quiz_score').value = lesson.passing_score || 70;
    }
    
    // Update button visibility regardless of current type
    var btnManage = document.getElementById('btn_manage_questions');
    if(btnManage) {
        // btnManage.href is no longer needed as it is a submit button
        // Reset display style in case it was hidden previously
        btnManage.style.display = ''; 
    }
    
    var modal = new bootstrap.Modal(document.getElementById('modalEditLesson'));
    modal.show();
}

function toggleEditLessonFields() {
    const type = document.getElementById('edit_lesson_type').value;
    const fieldVideo = document.getElementById('edit_field_video');
    const fieldText = document.getElementById('edit_field_text');
    const fieldQuiz = document.getElementById('edit_field_quiz');

    // Reset
    fieldVideo.style.display = 'none';
    fieldText.style.display = 'none';
    if(fieldQuiz) fieldQuiz.style.display = 'none';

    if (type === 'video') {
        fieldVideo.style.display = 'block';
    } else if (type === 'text' || type === 'pdf') {
        fieldText.style.display = 'block';
    } else if (type === 'quiz' || type === 'exam') {
        if(fieldQuiz) fieldQuiz.style.display = 'block';
    }
}
</script>

<?php require 'views/layouts/footer.php'; ?>
