<?php require 'views/layouts/home_header.php'; ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <h1 class="fw-bold text-primary mb-4 text-center">Entre em Contato</h1>
            <p class="text-center text-muted mb-5">Estamos aqui para ajudar! Preencha o formulário abaixo ou utilize nossos canais de atendimento.</p>
            
            <div class="row g-5">
                <div class="col-md-5">
                    <div class="bg-white p-4 rounded shadow-sm h-100">
                        <h5 class="fw-bold mb-4">Informações de Contato</h5>
                        
                        <div class="mb-4">
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-phone-alt text-primary me-3 fa-lg"></i>
                                <h6 class="mb-0 fw-bold">Telefone</h6>
                            </div>
                            <p class="text-muted ms-5"><?php echo get_setting('contact_phone') ?: '(11) 2364-6184'; ?></p>
                        </div>

                        <div class="mb-4">
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-envelope text-primary me-3 fa-lg"></i>
                                <h6 class="mb-0 fw-bold">E-mail</h6>
                            </div>
                            <p class="text-muted ms-5"><?php echo get_setting('contact_email') ?: 'contato@portal.com.br'; ?></p>
                        </div>

                        <div class="mb-4">
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-map-marker-alt text-primary me-3 fa-lg"></i>
                                <h6 class="mb-0 fw-bold">Localização</h6>
                            </div>
                            <p class="text-muted ms-5">São Paulo, SP</p>
                        </div>
                    </div>
                </div>

                <div class="col-md-7">
                    <div class="bg-white p-4 rounded shadow-sm">
                        <form>
                            <div class="mb-3">
                                <label class="form-label">Nome Completo</label>
                                <input type="text" class="form-control" placeholder="Seu nome">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">E-mail</label>
                                <input type="email" class="form-control" placeholder="seu@email.com">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Assunto</label>
                                <input type="text" class="form-control" placeholder="Motivo do contato">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Mensagem</label>
                                <textarea class="form-control" rows="5" placeholder="Escreva sua mensagem aqui..."></textarea>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary fw-bold py-2">Enviar Mensagem</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
