<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo defined('SITE_NAME') ? SITE_NAME : 'EAD Platform'; ?></title>
    
    <!-- Google Fonts: Inter -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo asset('css/style.css'); ?>">
</head>
<body class="d-flex flex-column min-vh-100">
    
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-custom sticky-top">
        <div class="container-fluid px-4">
            <a class="navbar-brand" href="<?php echo url(); ?>">
                <i class="fas fa-layer-group text-primary me-2"></i>EAD Platform
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo url('courses'); ?>">Cursos</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownCategories" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Categorias
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="navbarDropdownCategories">
                            <?php 
                            $cats = get_categories_helper();
                            if (!empty($cats)):
                                foreach ($cats as $cat): 
                            ?>
                                <li><a class="dropdown-item" href="<?php echo url('courses?category=' . $cat['id']); ?>"><?php echo htmlspecialchars($cat['name']); ?></a></li>
                            <?php 
                                endforeach; 
                            else:
                            ?>
                                <li><span class="dropdown-item text-muted">Nenhuma categoria</span></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php if (isLoggedIn()): ?>
                        <?php if (hasRole('admin')): ?>
                            <li class="nav-item"><a class="nav-link" href="<?php echo url('admin/dashboard'); ?>">Dashboard</a></li>
                        <?php elseif (hasRole('professor')): ?>
                            <li class="nav-item"><a class="nav-link" href="<?php echo url('professor/dashboard'); ?>">Painel do Professor</a></li>
                        <?php elseif (hasRole('student')): ?>
                            <li class="nav-item"><a class="nav-link" href="<?php echo url('student/my_courses'); ?>">Meus Cursos</a></li>
                        <?php endif; ?>
                    <?php endif; ?>
                </ul>
                
                <div class="d-flex align-items-center gap-3">
                    <button id="theme-toggle" class="btn btn-link nav-link p-0" title="Alternar Tema">
                        <i class="fas fa-moon"></i>
                    </button>

                    <?php if (isLoggedIn()): ?>
                        <div class="dropdown">
                            <a class="nav-link dropdown-toggle d-flex align-items-center gap-2" href="#" role="button" data-bs-toggle="dropdown">
                                <div class="avatar-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px; font-weight: 600;">
                                    <?php echo strtoupper(substr($_SESSION['user_name'], 0, 1)); ?>
                                </div>
                                <span class="d-none d-md-block"><?php echo $_SESSION['user_name']; ?></span>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0">
                                <li><a class="dropdown-item" href="<?php echo url('profile'); ?>"><i class="fas fa-user me-2"></i> Meu Perfil</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-danger" href="<?php echo url('logout'); ?>"><i class="fas fa-sign-out-alt me-2"></i> Sair</a></li>
                            </ul>
                        </div>
                    <?php else: ?>
                        <a href="<?php echo url('login'); ?>" class="btn btn-outline-primary btn-sm px-4">Entrar</a>
                        <a href="<?php echo url('register'); ?>" class="btn btn-primary btn-sm px-4">Cadastrar</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content Container -->
    <!-- Note: Views should close this div if they need full width, or work inside it -->
    <div class="flex-grow-1">
    
    <!-- Theme Toggle Script -->
    <script>
        const toggleButton = document.getElementById('theme-toggle');
        const body = document.body;
        const icon = toggleButton.querySelector('i');

        // Check localStorage
        const currentTheme = localStorage.getItem('theme');
        if (currentTheme === 'dark') {
            body.setAttribute('data-theme', 'dark');
            icon.classList.remove('fa-moon');
            icon.classList.add('fa-sun');
        }

        toggleButton.addEventListener('click', () => {
            if (body.getAttribute('data-theme') === 'dark') {
                body.removeAttribute('data-theme');
                localStorage.setItem('theme', 'light');
                icon.classList.remove('fa-sun');
                icon.classList.add('fa-moon');
            } else {
                body.setAttribute('data-theme', 'dark');
                localStorage.setItem('theme', 'dark');
                icon.classList.remove('fa-moon');
                icon.classList.add('fa-sun');
            }
        });
    </script>
