<?php require 'views/layouts/header.php'; ?>
<div class="d-flex">
    <?php require 'views/layouts/admin_sidebar.php'; ?>
    <div class="content p-4 w-100">
        <h2 class="mb-4">Configurações do Site</h2>
        
        <form action="<?php echo url('admin/update_settings'); ?>" method="POST" enctype="multipart/form-data">
            
            <ul class="nav nav-tabs mb-4" id="settingsTab" role="tablist">
                <li class="nav-item">
                    <button class="nav-link active" id="general-tab" data-bs-toggle="tab" data-bs-target="#general" type="button">Geral</button>
                </li>
                <li class="nav-item">
                    <button class="nav-link" id="hero-tab" data-bs-toggle="tab" data-bs-target="#hero" type="button">Home - Destaque</button>
                </li>
                <li class="nav-item">
                    <button class="nav-link" id="stats-tab" data-bs-toggle="tab" data-bs-target="#stats" type="button">Estatísticas</button>
                </li>
                <li class="nav-item">
                    <button class="nav-link" id="contacts-tab" data-bs-toggle="tab" data-bs-target="#contacts" type="button">Contatos & Redes</button>
                </li>
                <li class="nav-item">
                    <button class="nav-link" id="payment-tab" data-bs-toggle="tab" data-bs-target="#payment" type="button">Pagamentos</button>
                </li>
                <li class="nav-item">
                    <button class="nav-link" id="whatsapp-tab" data-bs-toggle="tab" data-bs-target="#whatsapp" type="button"><i class="fab fa-whatsapp text-success me-1"></i> WhatsApp</button>
                </li>
                <li class="nav-item">
                    <button class="nav-link" id="promo-tab" data-bs-toggle="tab" data-bs-target="#promo" type="button"><i class="fas fa-bullhorn text-danger me-1"></i> Promoção</button>
                </li>
            </ul>

            <div class="tab-content" id="settingsTabContent">
                <!-- Geral -->
                <div class="tab-pane fade show active" id="general">
                    <div class="mb-3">
                        <label class="form-label">Nome do Site</label>
                        <input type="text" name="site_name" class="form-control" value="<?php echo $settings['site_name'] ?? ''; ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Logo do Site</label>
                        <?php if(!empty($settings['site_logo'])): ?>
                            <div class="mb-2">
                                <img src="<?php echo url('uploads/' . $settings['site_logo']); ?>" alt="Logo" style="max-height: 50px;">
                            </div>
                        <?php endif; ?>
                        <input type="file" name="logo_file" class="form-control">
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Cor Primária</label>
                            <input type="color" name="primary_color" class="form-control form-control-color" value="<?php echo $settings['primary_color'] ?? '#0d6efd'; ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Cor Secundária</label>
                            <input type="color" name="secondary_color" class="form-control form-control-color" value="<?php echo $settings['secondary_color'] ?? '#ffc107'; ?>">
                        </div>
                    </div>
                </div>

                <!-- Home - Destaque (Hero) -->
                <div class="tab-pane fade" id="hero">
                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-3">Seção Principal</h5>
                            <div class="mb-3">
                                <label class="form-label">Imagem de Fundo</label>
                                <?php if(!empty($settings['home_hero_bg'])): ?>
                                    <div class="mb-2">
                                        <img src="<?php echo url('uploads/' . $settings['home_hero_bg']); ?>" alt="Background" style="max-height: 100px; max-width: 100%;">
                                    </div>
                                <?php endif; ?>
                                <input type="file" name="hero_bg_file" class="form-control">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Título Principal</label>
                                <input type="text" name="home_hero_title" class="form-control" value="<?php echo $settings['home_hero_title'] ?? ''; ?>">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Subtítulo</label>
                                <input type="text" name="home_hero_subtext" class="form-control" value="<?php echo $settings['home_hero_subtext'] ?? ''; ?>">
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Texto do Botão</label>
                                    <input type="text" name="home_hero_btn_text" class="form-control" value="<?php echo $settings['home_hero_btn_text'] ?? ''; ?>">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Link do Botão</label>
                                    <input type="text" name="home_hero_btn_link" class="form-control" value="<?php echo $settings['home_hero_btn_link'] ?? ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5 class="mb-3">Card de Certificados</h5>
                            <div class="mb-3">
                                <label class="form-label">Título do Card</label>
                                <input type="text" name="home_cert_title" class="form-control" value="<?php echo $settings['home_cert_title'] ?? ''; ?>">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Itens (um por linha)</label>
                                <textarea name="home_cert_items" class="form-control" rows="5"><?php echo $settings['home_cert_items'] ?? ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Estatísticas -->
                <div class="tab-pane fade" id="stats">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="card p-3">
                                <h6>Estatística 1 (Esquerda)</h6>
                                <div class="mb-2">
                                    <label class="form-label">Número</label>
                                    <input type="text" name="stat_courses_count" class="form-control" value="<?php echo $settings['stat_courses_count'] ?? ''; ?>">
                                </div>
                                <div class="mb-2">
                                    <label class="form-label">Rótulo</label>
                                    <input type="text" name="stat_courses_label" class="form-control" value="<?php echo $settings['stat_courses_label'] ?? ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card p-3">
                                <h6>Estatística 2 (Centro)</h6>
                                <div class="mb-2">
                                    <label class="form-label">Número</label>
                                    <input type="text" name="stat_students_count" class="form-control" value="<?php echo $settings['stat_students_count'] ?? ''; ?>">
                                </div>
                                <div class="mb-2">
                                    <label class="form-label">Rótulo</label>
                                    <input type="text" name="stat_students_label" class="form-control" value="<?php echo $settings['stat_students_label'] ?? ''; ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card p-3">
                                <h6>Estatística 3 (Direita)</h6>
                                <div class="mb-2">
                                    <label class="form-label">Número</label>
                                    <input type="text" name="stat_certificates_count" class="form-control" value="<?php echo $settings['stat_certificates_count'] ?? ''; ?>">
                                </div>
                                <div class="mb-2">
                                    <label class="form-label">Rótulo</label>
                                    <input type="text" name="stat_certificates_label" class="form-control" value="<?php echo $settings['stat_certificates_label'] ?? ''; ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contatos & Redes -->
                <div class="tab-pane fade" id="contacts">
                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="mb-3">Contato</h5>
                            <div class="mb-3">
                                <label class="form-label">Telefone</label>
                                <input type="text" name="contact_phone" class="form-control" value="<?php echo $settings['contact_phone'] ?? ''; ?>">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">E-mail</label>
                                <input type="text" name="contact_email" class="form-control" value="<?php echo $settings['contact_email'] ?? ''; ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5 class="mb-3">Redes Sociais</h5>
                            <div class="mb-3">
                                <label class="form-label">Facebook (URL)</label>
                                <input type="text" name="social_facebook" class="form-control" value="<?php echo $settings['social_facebook'] ?? ''; ?>">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Instagram (URL)</label>
                                <input type="text" name="social_instagram" class="form-control" value="<?php echo $settings['social_instagram'] ?? ''; ?>">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">LinkedIn (URL)</label>
                                <input type="text" name="social_linkedin" class="form-control" value="<?php echo $settings['social_linkedin'] ?? ''; ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pagamentos -->
                <div class="tab-pane fade" id="payment">
                    <div class="alert alert-info">
                        Configure as credenciais do Mercado Pago para processar pagamentos.
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Access Token (Produção ou Teste)</label>
                        <input type="text" name="mp_access_token" class="form-control" value="<?php echo $settings['mp_access_token'] ?? ''; ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Public Key</label>
                        <input type="text" name="mp_public_key" class="form-control" value="<?php echo $settings['mp_public_key'] ?? ''; ?>">
                    </div>

                    <hr class="my-4">
                    
                    <h5 class="mb-3 text-success"><i class="fab fa-pix me-2"></i> Pix Manual</h5>
                    <div class="alert alert-light border-start border-success border-4">
                        Configure uma chave Pix para receber pagamentos diretamente, sem taxas de intermediários.
                    </div>
                    
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" id="pix_manual_active" name="pix_manual_active" value="1" <?php echo ($settings['pix_manual_active'] ?? 0) ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="pix_manual_active">Ativar Pix Manual</label>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Tipo de Chave</label>
                            <select name="pix_key_type" class="form-select">
                                <option value="cpf" <?php echo ($settings['pix_key_type'] ?? '') == 'cpf' ? 'selected' : ''; ?>>CPF</option>
                                <option value="cnpj" <?php echo ($settings['pix_key_type'] ?? '') == 'cnpj' ? 'selected' : ''; ?>>CNPJ</option>
                                <option value="email" <?php echo ($settings['pix_key_type'] ?? '') == 'email' ? 'selected' : ''; ?>>E-mail</option>
                                <option value="phone" <?php echo ($settings['pix_key_type'] ?? '') == 'phone' ? 'selected' : ''; ?>>Celular</option>
                                <option value="random" <?php echo ($settings['pix_key_type'] ?? '') == 'random' ? 'selected' : ''; ?>>Chave Aleatória</option>
                            </select>
                        </div>
                        <div class="col-md-8 mb-3">
                            <label class="form-label">Chave Pix</label>
                            <input type="text" name="pix_key" class="form-control" value="<?php echo $settings['pix_key'] ?? ''; ?>" placeholder="Digite sua chave Pix">
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Nome do Beneficiário</label>
                        <input type="text" name="pix_beneficiary" class="form-control" value="<?php echo $settings['pix_beneficiary'] ?? ''; ?>" placeholder="Nome que aparecerá no comprovante">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Instruções de Pagamento</label>
                        <textarea name="pix_instructions" class="form-control" rows="3" placeholder="Ex: Envie o comprovante para o WhatsApp..."><?php echo $settings['pix_instructions'] ?? ''; ?></textarea>
                    </div>
                </div>

                <!-- WhatsApp -->
                <div class="tab-pane fade" id="whatsapp">
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input type="hidden" name="whatsapp_active" value="0">
                            <input class="form-check-input" type="checkbox" id="whatsapp_active" name="whatsapp_active" value="1" <?php echo ($settings['whatsapp_active'] ?? 0) ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="whatsapp_active">Ativar Widget do WhatsApp</label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Número do WhatsApp</label>
                        <input type="text" name="whatsapp_number" class="form-control" value="<?php echo $settings['whatsapp_number'] ?? ''; ?>" placeholder="Ex: 5511999999999">
                        <div class="form-text">Digite apenas números, incluindo o código do país (55 para Brasil).</div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Mensagem Padrão</label>
                        <input type="text" name="whatsapp_message" class="form-control" value="<?php echo $settings['whatsapp_message'] ?? ''; ?>" placeholder="Olá! Gostaria de mais informações.">
                    </div>
                </div>

                <!-- Promoção -->
                <div class="tab-pane fade" id="promo">
                    <div class="mb-3">
                        <div class="form-check form-switch">
                            <input type="hidden" name="promo_bar_active" value="0">
                            <input class="form-check-input" type="checkbox" id="promo_bar_active" name="promo_bar_active" value="1" <?php echo ($settings['promo_bar_active'] ?? 0) ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="promo_bar_active">Ativar Barra de Promoção</label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Texto da Promoção</label>
                        <input type="text" name="promo_bar_text" class="form-control" value="<?php echo $settings['promo_bar_text'] ?? ''; ?>" placeholder="Ex: Aproveite 50% de desconto em todos os cursos!">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Link do Botão (Opcional)</label>
                        <input type="text" name="promo_bar_link" class="form-control" value="<?php echo $settings['promo_bar_link'] ?? ''; ?>" placeholder="Ex: http://seusite.com/cursos">
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Cor de Fundo</label>
                            <input type="color" name="promo_bar_bg" class="form-control form-control-color" value="<?php echo $settings['promo_bar_bg'] ?? '#dc3545'; ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Cor do Texto</label>
                            <input type="color" name="promo_bar_color" class="form-control form-control-color" value="<?php echo $settings['promo_bar_color'] ?? '#ffffff'; ?>">
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Salvar Configurações</button>
            </div>
        </form>
    </div>
</div>
<?php require 'views/layouts/footer.php'; ?>