<?php require 'views/layouts/header.php'; ?>
<div class="d-flex">
    <?php require 'views/layouts/admin_sidebar.php'; ?>
    <div class="content p-4 w-100">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Gerenciar Menus</h2>
            <a href="<?php echo url('admin/create_menu_item'); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> Novo Item</a>
        </div>
        
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <?php
                // Agrupar por localização
                $grouped = [];
                foreach ($menuItems as $item) {
                    $grouped[$item['menu_location']][] = $item;
                }
                ?>

                <?php if(empty($grouped)): ?>
                    <p class="text-muted">Nenhum item de menu cadastrado.</p>
                <?php else: ?>
                    <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                        <?php $first = true; foreach($grouped as $loc => $items): ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php echo $first ? 'active' : ''; ?>" id="pills-<?php echo $loc; ?>-tab" data-bs-toggle="pill" data-bs-target="#pills-<?php echo $loc; ?>" type="button" role="tab" aria-selected="<?php echo $first ? 'true' : 'false'; ?>">
                                    <?php echo ucfirst(str_replace('_', ' ', $loc)); ?>
                                </button>
                            </li>
                        <?php $first = false; endforeach; ?>
                    </ul>
                    
                    <div class="tab-content" id="pills-tabContent">
                        <?php $first = true; foreach($grouped as $loc => $items): ?>
                            <div class="tab-pane fade <?php echo $first ? 'show active' : ''; ?>" id="pills-<?php echo $loc; ?>" role="tabpanel">
                                <div class="table-responsive">
                                    <table class="table table-hover align-middle">
                                        <thead>
                                            <tr>
                                                <th>Rótulo</th>
                                                <th>Link</th>
                                                <th>Ordem</th>
                                                <th class="text-end">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach($items as $item): ?>
                                                <tr>
                                                    <td class="fw-bold"><?php echo $item['label']; ?></td>
                                                    <td class="text-muted"><?php echo $item['link']; ?></td>
                                                    <td><?php echo $item['order_index']; ?></td>
                                                    <td class="text-end">
                                                        <a href="<?php echo url('admin/edit_menu_item/' . $item['id']); ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                                        <a href="<?php echo url('admin/delete_menu_item/' . $item['id']); ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Tem certeza?')"><i class="fas fa-trash"></i></a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        <?php $first = false; endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php require 'views/layouts/footer.php'; ?>