<?php require 'views/layouts/header.php'; ?>
<?php $activePage = 'home_buttons'; ?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/admin_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2 class="h3 mb-0 text-gray-800">Botões da Página Inicial</h2>
                <a href="<?php echo url('admin/create_home_button'); ?>" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Novo Botão
                </a>
            </div>

            <div class="card shadow mb-4">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" width="100%" cellspacing="0">
                            <thead class="table-light">
                                <tr>
                                    <th>Texto</th>
                                    <th>Ícone</th>
                                    <th>Link</th>
                                    <th>Cor</th>
                                    <th>Ordem</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($buttons as $button): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($button['text']); ?></td>
                                        <td><i class="<?php echo htmlspecialchars($button['icon']); ?> fa-lg"></i> (<?php echo htmlspecialchars($button['icon']); ?>)</td>
                                        <td><?php echo htmlspecialchars($button['link']); ?></td>
                                        <td><span class="badge <?php echo str_replace('btn-outline-', 'bg-', $button['color_class']); ?> text-white"><?php echo htmlspecialchars($button['color_class']); ?></span></td>
                                        <td><?php echo $button['sort_order']; ?></td>
                                        <td>
                                            <?php if ($button['active']): ?>
                                                <span class="badge bg-success">Ativo</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Inativo</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href="<?php echo url('admin/edit_home_button/' . $button['id']); ?>" class="btn btn-sm btn-info text-white" title="Editar">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="<?php echo url('admin/delete_home_button/' . $button['id']); ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza que deseja excluir?')" title="Excluir">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                <?php if (empty($buttons)): ?>
                                    <tr>
                                        <td colspan="7" class="text-center py-3">Nenhum botão encontrado.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>