<?php require 'views/layouts/header.php'; ?>
<div class="d-flex">
    <?php require 'views/layouts/admin_sidebar.php'; ?>
    <div class="content p-4 w-100">
        <h2 class="mb-4">Editar Anúncio</h2>
        
        <form action="<?php echo url('admin/edit_ad/' . $ad['id']); ?>" method="POST" enctype="multipart/form-data">
            <div class="row">
                <div class="col-md-8">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Título (Interno)</label>
                                <input type="text" name="title" class="form-control" value="<?php echo $ad['title']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Imagem do Anúncio</label>
                                <div class="mb-2">
                                    <img src="<?php echo url('uploads/' . $ad['image']); ?>" style="max-height: 100px;">
                                </div>
                                <input type="file" name="image" class="form-control">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Link de Destino</label>
                                <input type="url" name="link" class="form-control" value="<?php echo $ad['link']; ?>" required>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Localização</label>
                                    <select name="location" class="form-select">
                                        <option value="home_top" <?php echo $ad['location'] == 'home_top' ? 'selected' : ''; ?>>Home - Topo (Abaixo do Menu)</option>
                                        <option value="home_middle" <?php echo $ad['location'] == 'home_middle' ? 'selected' : ''; ?>>Home - Meio (Entre seções)</option>
                                        <option value="home_bottom" <?php echo $ad['location'] == 'home_bottom' ? 'selected' : ''; ?>>Home - Rodapé</option>
                                        <option value="sidebar" <?php echo $ad['location'] == 'sidebar' ? 'selected' : ''; ?>>Sidebar (Cursos)</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Status</label>
                                    <div class="form-check form-switch mt-2">
                                        <input class="form-check-input" type="checkbox" name="active" <?php echo $ad['active'] ? 'checked' : ''; ?>>
                                        <label class="form-check-label">Ativo</label>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Atualizar Anúncio</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php require 'views/layouts/footer.php'; ?>
