<?php require 'views/layouts/header.php'; ?>
<?php $activePage = 'dashboard'; ?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/admin_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Dashboard</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <button type="button" class="btn btn-sm btn-outline-secondary">Compartilhar</button>
                        <button type="button" class="btn btn-sm btn-outline-secondary">Exportar</button>
                    </div>
                    <button type="button" class="btn btn-sm btn-outline-secondary dropdown-toggle">
                        <span data-feather="calendar"></span>
                        Esta semana
                    </button>
                </div>
            </div>

            <!-- Stats Cards -->
            <div class="row g-4 mb-4">
                <div class="col-md-4 col-xl-3">
                    <div class="card h-100 border-start border-4 border-primary">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted mb-1 text-uppercase fw-bold" style="font-size: 0.8rem;">Total de Usuários</p>
                                    <h3 class="mb-0 fw-bold"><?php echo isset($stats['users']) ? number_format($stats['users']) : 0; ?></h3>
                                </div>
                                <div class="icon-shape bg-primary text-white rounded p-3">
                                    <i class="fas fa-users fa-lg"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-xl-3">
                    <div class="card h-100 border-start border-4 border-success">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted mb-1 text-uppercase fw-bold" style="font-size: 0.8rem;">Cursos Ativos</p>
                                    <h3 class="mb-0 fw-bold"><?php echo isset($stats['courses']) ? number_format($stats['courses']) : 0; ?></h3>
                                </div>
                                <div class="icon-shape bg-success text-white rounded p-3">
                                    <i class="fas fa-graduation-cap fa-lg"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-xl-3">
                    <div class="card h-100 border-start border-4 border-warning">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted mb-1 text-uppercase fw-bold" style="font-size: 0.8rem;">Vendas (Aprovadas)</p>
                                    <h3 class="mb-0 fw-bold">R$ <?php echo isset($stats['sales']) ? number_format($stats['sales'], 2, ',', '.') : '0,00'; ?></h3>
                                </div>
                                <div class="icon-shape bg-warning text-white rounded p-3">
                                    <i class="fas fa-dollar-sign fa-lg"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                 <div class="col-md-4 col-xl-3">
                    <div class="card h-100 border-start border-4 border-info">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted mb-1 text-uppercase fw-bold" style="font-size: 0.8rem;">Novos Alunos</p>
                                    <h3 class="mb-0 fw-bold">+12</h3>
                                </div>
                                <div class="icon-shape bg-info text-white rounded p-3">
                                    <i class="fas fa-user-plus fa-lg"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Charts -->
            <div class="row">
                <div class="col-md-8">
                    <div class="card mb-4 shadow-sm">
                        <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-primary"><i class="fas fa-chart-line me-2"></i>Vendas (Últimos 6 Meses)</h5>
                        </div>
                        <div class="card-body">
                            <canvas id="salesChart" width="100%" height="40"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card mb-4 shadow-sm">
                        <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-primary"><i class="fas fa-chart-pie me-2"></i>Distribuição</h5>
                        </div>
                        <div class="card-body">
                            <canvas id="usersChart" width="100%" height="40"></canvas>
                        </div>
                    </div>
                </div>
            </div>

        </main>
    </div>
</div>

<script>
    // Configuração do Gráfico de Vendas
    const ctxSales = document.getElementById('salesChart').getContext('2d');
    const salesChart = new Chart(ctxSales, {
        type: 'line',
        data: {
            labels: ['Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            datasets: [{
                label: 'Vendas (R$)',
                data: [1200, 1900, 3000, 5000, 2000, 3000],
                backgroundColor: 'rgba(111, 66, 193, 0.1)',
                borderColor: '#6f42c1',
                borderWidth: 2,
                tension: 0.4,
                fill: true,
                pointBackgroundColor: '#fff',
                pointBorderColor: '#6f42c1',
                pointBorderWidth: 2,
                pointRadius: 4,
                pointHoverRadius: 6
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        borderDash: [2, 4],
                        color: '#e9ecef'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // Configuração do Gráfico de Usuários
    const ctxUsers = document.getElementById('usersChart').getContext('2d');
    const usersChart = new Chart(ctxUsers, {
        type: 'doughnut',
        data: {
            labels: ['Alunos', 'Professores', 'Tutores', 'Admin'],
            datasets: [{
                data: [70, 15, 10, 5],
                backgroundColor: [
                    '#6f42c1',
                    '#0dcaf0',
                    '#ffc107',
                    '#dc3545'
                ],
                borderWidth: 0,
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            cutout: '70%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        usePointStyle: true,
                        padding: 20
                    }
                }
            }
        }
    });
</script>

<?php require 'views/layouts/footer.php'; ?>
