<?php require 'views/layouts/header.php'; ?>
<div class="d-flex">
    <?php require 'views/layouts/admin_sidebar.php'; ?>
    <div class="content p-4 w-100">
        <h2 class="mb-4">Novo Anúncio</h2>
        
        <form action="<?php echo url('admin/create_ad'); ?>" method="POST" enctype="multipart/form-data">
            <div class="row">
                <div class="col-md-8">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Título (Interno)</label>
                                <input type="text" name="title" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Imagem do Anúncio</label>
                                <input type="file" name="image" class="form-control" required>
                                <div class="form-text">Recomendado: 728x90 para banners horizontais, 300x250 para sidebar.</div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Link de Destino</label>
                                <input type="url" name="link" class="form-control" placeholder="https://..." required>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Localização</label>
                                    <select name="location" class="form-select">
                                        <option value="home_top">Home - Topo (Abaixo do Menu)</option>
                                        <option value="home_middle">Home - Meio (Entre seções)</option>
                                        <option value="home_bottom">Home - Rodapé</option>
                                        <option value="sidebar">Sidebar (Cursos)</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Status</label>
                                    <div class="form-check form-switch mt-2">
                                        <input class="form-check-input" type="checkbox" name="active" checked>
                                        <label class="form-check-label">Ativo</label>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Salvar Anúncio</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php require 'views/layouts/footer.php'; ?>
