<?php require 'views/layouts/header.php'; ?>
<?php $activePage = 'certificate_settings'; ?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/admin_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <h2 class="h3 mb-4 text-gray-800">Configurações de Certificado</h2>

            <form action="<?php echo url('admin/certificate_settings'); ?>" method="POST" enctype="multipart/form-data">
                
                <!-- Seção da Home Page -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Seção na Página Inicial</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3 form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="home_cert_active" name="home_cert_active" value="1" <?php echo get_setting('home_cert_active') ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="home_cert_active">Exibir seção de certificado na Home</label>
                        </div>

                        <div class="mb-3">
                            <label for="home_cert_title" class="form-label">Título da Seção</label>
                            <input type="text" class="form-control" id="home_cert_title" name="home_cert_title" value="<?php echo htmlspecialchars(get_setting('home_cert_title')); ?>">
                        </div>

                        <div class="mb-3">
                            <label for="home_cert_items" class="form-label">Itens Legais (um por linha)</label>
                            <textarea class="form-control" id="home_cert_items" name="home_cert_items" rows="5"><?php echo htmlspecialchars(get_setting('home_cert_items')); ?></textarea>
                        </div>

                        <div class="mb-3">
                            <label for="home_cert_image" class="form-label">Imagem Promocional (Home)</label>
                            <input class="form-control" type="file" id="home_cert_image" name="home_cert_image" accept="image/*">
                            <?php if (get_setting('home_cert_image')): ?>
                                <div class="mt-2">
                                    <img src="<?php echo url('uploads/' . get_setting('home_cert_image')); ?>" alt="Imagem Atual" class="img-thumbnail" style="max-height: 150px;">
                                </div>
                            <?php endif; ?>
                        </div>

                        <hr class="my-4">
                        <h6 class="fw-bold mb-3">Personalização de Cores</h6>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Cor de Destaque (Texto)</label>
                                <input type="color" class="form-control form-control-color" name="home_cert_color_highlight" value="<?php echo get_setting('home_cert_color_highlight') ?: '#ffc107'; ?>" title="Escolha a cor">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Cor do Ícone (Check)</label>
                                <input type="color" class="form-control form-control-color" name="home_cert_color_icon" value="<?php echo get_setting('home_cert_color_icon') ?: '#ffc107'; ?>" title="Escolha a cor">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Seção de Segurança do Certificado (Validação) -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Seção de Segurança (Validação)</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="cert_security_badge" class="form-label">Texto do Badge (Ex: Segurança)</label>
                            <input type="text" class="form-control" id="cert_security_badge" name="cert_security_badge" value="<?php echo htmlspecialchars(get_setting('cert_security_badge') ?: 'Segurança'); ?>">
                        </div>

                        <div class="mb-3">
                            <label for="cert_security_title" class="form-label">Título da Seção</label>
                            <input type="text" class="form-control" id="cert_security_title" name="cert_security_title" value="<?php echo htmlspecialchars(get_setting('cert_security_title') ?: 'Segurança para quem emite e quem recebe o certificado'); ?>">
                        </div>

                        <div class="mb-3">
                            <label for="cert_security_text" class="form-label">Texto Descritivo</label>
                            <textarea class="form-control" id="cert_security_text" name="cert_security_text" rows="4"><?php echo htmlspecialchars(get_setting('cert_security_text') ?: 'A autenticidade do seu certificado poderá ser verificada através do QR CODE ou pelo código de validação presente no certificado.'); ?></textarea>
                        </div>
                        
                        <hr class="my-4">
                        <h6 class="fw-bold mb-3">Caixa de Ajuda (Validação)</h6>
                        <div class="row">
                             <div class="col-md-12 mb-3">
                                <label class="form-label">Texto de Ajuda</label>
                                <input type="text" class="form-control" name="cert_help_text" value="<?php echo htmlspecialchars(get_setting('cert_help_text') ?: 'Tem alguma dúvida sobre a Plataforma?'); ?>">
                             </div>
                             <div class="col-md-6 mb-3">
                                <label class="form-label">Texto do Botão</label>
                                <input type="text" class="form-control" name="cert_help_btn_text" value="<?php echo htmlspecialchars(get_setting('cert_help_btn_text') ?: 'Buscar Informações'); ?>">
                             </div>
                             <div class="col-md-6 mb-3">
                                <label class="form-label">Link do Botão</label>
                                <input type="text" class="form-control" name="cert_help_btn_link" value="<?php echo htmlspecialchars(get_setting('cert_help_btn_link') ?: '#'); ?>">
                             </div>
                        </div>

                        <hr class="my-4">
                        <h6 class="fw-bold mb-3">Personalização de Cores</h6>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Cor do Badge (Segurança)</label>
                                <input type="color" class="form-control form-control-color" name="cert_color_badge" value="<?php echo get_setting('cert_color_badge') ?: '#ffc107'; ?>" title="Escolha a cor">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Cor do Botão de Pesquisa</label>
                                <input type="color" class="form-control form-control-color" name="cert_color_search_btn" value="<?php echo get_setting('cert_color_search_btn') ?: '#ffc107'; ?>" title="Escolha a cor">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Cor do Fundo da Ajuda</label>
                                <input type="color" class="form-control form-control-color" name="cert_color_help_bg" value="<?php echo get_setting('cert_color_help_bg') ?: '#fff3cd'; ?>" title="Escolha a cor">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Cor do Botão de Ajuda</label>
                                <input type="color" class="form-control form-control-color" name="cert_color_help_btn" value="<?php echo get_setting('cert_color_help_btn') ?: '#6f42c1'; ?>" title="Escolha a cor">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Configuração do Modelo de Certificado -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Modelo do Certificado (PDF)</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="cert_template_bg" class="form-label">Imagem de Fundo do Certificado</label>
                            <input class="form-control" type="file" id="cert_template_bg" name="cert_template_bg" accept="image/*">
                            <?php if (get_setting('cert_template_bg')): ?>
                                <div class="mt-2">
                                    <img src="<?php echo url('uploads/' . get_setting('cert_template_bg')); ?>" alt="Fundo Atual" class="img-thumbnail" style="max-height: 150px;">
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="cert_signer_name" class="form-label">Nome do Responsável</label>
                                <input type="text" class="form-control" id="cert_signer_name" name="cert_signer_name" value="<?php echo htmlspecialchars(get_setting('cert_signer_name')); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="cert_signer_role" class="form-label">Cargo do Responsável</label>
                                <input type="text" class="form-control" id="cert_signer_role" name="cert_signer_role" value="<?php echo htmlspecialchars(get_setting('cert_signer_role')); ?>">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="cert_signer_signature" class="form-label">Assinatura Digital</label>
                            <input class="form-control" type="file" id="cert_signer_signature" name="cert_signer_signature" accept="image/*">
                            <?php if (get_setting('cert_signer_signature')): ?>
                                <div class="mt-2">
                                    <img src="<?php echo url('uploads/' . get_setting('cert_signer_signature')); ?>" alt="Assinatura Atual" class="img-thumbnail" style="max-height: 80px;">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="mb-4">
                    <button type="submit" class="btn btn-success btn-lg"><i class="fas fa-save me-2"></i>Salvar Configurações</button>
                </div>

            </form>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
