<?php require 'views/layouts/header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <?php 
        $activePage = 'dashboard';
        require 'views/layouts/tutor_sidebar.php'; 
        ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Dashboard do Tutor</h1>
            </div>

            <div class="row">
                <?php foreach($courses as $course): ?>
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                        <?php if($course['image']): ?>
                            <img src="<?php echo url('uploads/' . $course['image']); ?>" class="card-img-top" alt="<?php echo $course['title']; ?>" style="height: 180px; object-fit: cover;">
                        <?php else: ?>
                            <div class="bg-light text-center py-5">
                                <i class="fas fa-book fa-3x text-muted opacity-50"></i>
                            </div>
                        <?php endif; ?>
                        
                        <div class="card-body">
                            <h5 class="card-title fw-bold text-primary mb-3"><?php echo $course['title']; ?></h5>
                            
                            <div class="d-flex justify-content-between mb-3 text-muted small">
                                <span><i class="fas fa-users me-1"></i> <?php echo $course['total_students']; ?> Alunos</span>
                                <span><i class="fas fa-comments me-1"></i> <?php echo $course['total_questions']; ?> Dúvidas</span>
                            </div>

                            <div class="d-grid gap-2">
                                <a href="<?php echo url('tutor/course/' . $course['id']); ?>" class="btn btn-outline-primary btn-sm">
                                    <i class="fas fa-eye me-1"></i> Ver Conteúdo
                                </a>
                                <a href="<?php echo url('tutor/students/' . $course['id']); ?>" class="btn btn-outline-info btn-sm">
                                    <i class="fas fa-user-graduate me-1"></i> Acompanhar Alunos
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
                
                <?php if(empty($courses)): ?>
                    <div class="col-12">
                        <div class="alert alert-info d-flex align-items-center" role="alert">
                            <i class="fas fa-info-circle me-2"></i>
                            <div>
                                Você não possui cursos vinculados no momento.
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
