<?php 
$activePage = 'my_courses';
require 'views/layouts/header.php'; 
?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/student_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-4 border-bottom">
                <h1 class="h2">Meus Cursos</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <a href="<?php echo url('courses'); ?>" class="btn btn-sm btn-outline-primary">
                        <i class="fas fa-search me-1"></i> Explorar Novos Cursos
                    </a>
                </div>
            </div>

            <?php if (count($courses) > 0): ?>
                <div class="row row-cols-1 row-cols-md-2 row-cols-xl-3 g-4">
                    <?php foreach ($courses as $course): ?>
                        <div class="col">
                            <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
                                <?php if($course['image']): ?>
                                    <div class="position-relative">
                                        <img src="<?php echo asset('uploads/' . $course['image']); ?>" class="card-img-top" alt="<?php echo $course['title']; ?>" style="height: 180px; object-fit: cover;">
                                        <div class="position-absolute top-0 end-0 p-2">
                                            <span class="badge bg-light text-dark shadow-sm">
                                                <i class="fas fa-calendar-alt me-1"></i> <?php echo date('d/m/Y', strtotime($course['enrolled_at'])); ?>
                                            </span>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 180px;">
                                        <i class="fas fa-book-open fa-3x text-secondary"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="card-body d-flex flex-column">
                                    <h5 class="card-title fw-bold text-truncate" title="<?php echo $course['title']; ?>"><?php echo $course['title']; ?></h5>
                                    
                                    <div class="mt-auto">
                                        <div class="d-flex justify-content-between align-items-center mb-1">
                                            <small class="text-muted fw-bold">Progresso</small>
                                            <small class="text-primary fw-bold"><?php echo $course['progress']; ?>%</small>
                                        </div>
                                        <div class="progress mb-3" style="height: 8px;">
                                            <div class="progress-bar bg-primary rounded-pill" role="progressbar" style="width: <?php echo $course['progress']; ?>%;" aria-valuenow="<?php echo $course['progress']; ?>" aria-valuemin="0" aria-valuemax="100"></div>
                                        </div>

                                        <div class="d-grid gap-2">
                                            <a href="<?php echo url('student/classroom/' . $course['id']); ?>" class="btn btn-primary">
                                                <i class="fas fa-play-circle me-2"></i> Continuar
                                            </a>
                                            
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#reviewModal<?php echo $course['id']; ?>">
                                                    <i class="fas fa-star me-1"></i> Avaliar
                                                </button>
                                                <?php if($course['progress'] == 100): ?>
                                                    <a href="<?php echo url('student/certificate/' . $course['id']); ?>" target="_blank" class="btn btn-outline-success btn-sm">
                                                        <i class="fas fa-certificate me-1"></i> Certificado
                                                    </a>
                                                <?php else: ?>
                                                    <button class="btn btn-outline-secondary btn-sm" disabled title="Conclua o curso para emitir o certificado">
                                                        <i class="fas fa-lock me-1"></i> Certificado
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Modal de Avaliação -->
                        <div class="modal fade" id="reviewModal<?php echo $course['id']; ?>" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Avaliar <?php echo $course['title']; ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="<?php echo url('student/save_review'); ?>" method="POST">
                                        <div class="modal-body">
                                            <input type="hidden" name="course_id" value="<?php echo $course['id']; ?>">
                                            <div class="mb-3">
                                                <label class="form-label">Sua Nota</label>
                                                <div class="rating-select d-flex justify-content-center gap-3 display-6 text-warning mb-2">
                                                    <i class="far fa-star" data-value="1"></i>
                                                    <i class="far fa-star" data-value="2"></i>
                                                    <i class="far fa-star" data-value="3"></i>
                                                    <i class="far fa-star" data-value="4"></i>
                                                    <i class="far fa-star" data-value="5"></i>
                                                </div>
                                                <input type="hidden" name="rating" id="ratingInput<?php echo $course['id']; ?>" required>
                                                <p class="text-center text-muted small" id="ratingText<?php echo $course['id']; ?>">Selecione as estrelas</p>
                                            </div>
                                            <div class="mb-3">
                                                <label for="comment" class="form-label">Comentário (Opcional)</label>
                                                <textarea class="form-control" name="comment" rows="3" placeholder="O que você achou deste curso?"></textarea>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                                            <button type="submit" class="btn btn-primary">Enviar Avaliação</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <script>
                // Script simples para seleção de estrelas
                document.querySelectorAll('.rating-select i').forEach(star => {
                    star.style.cursor = 'pointer';
                    star.addEventListener('click', function() {
                        const val = this.dataset.value;
                        const container = this.parentElement;
                        const input = container.nextElementSibling;
                        const text = input.nextElementSibling;
                        
                        input.value = val;
                        
                        // Atualizar visual
                        container.querySelectorAll('i').forEach(s => {
                            if (s.dataset.value <= val) {
                                s.classList.remove('far');
                                s.classList.add('fas');
                            } else {
                                s.classList.remove('fas');
                                s.classList.add('far');
                            }
                        });
                        
                        const labels = ['Ruim', 'Regular', 'Bom', 'Muito Bom', 'Excelente'];
                        text.innerText = labels[val-1];
                    });
                });
                </script>
            <?php else: ?>
                <div class="text-center py-5">
                    <div class="mb-4">
                        <i class="fas fa-book-reader fa-4x text-muted opacity-50"></i>
                    </div>
                    <h3>Você ainda não começou a aprender</h3>
                    <p class="text-muted">Explore nosso catálogo e comece sua jornada hoje mesmo.</p>
                    <a href="<?php echo url('courses'); ?>" class="btn btn-primary btn-lg mt-3">
                        Explorar Cursos
                    </a>
                </div>
            <?php endif; ?>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
