<?php require 'views/layouts/header.php'; ?>
<?php $activePage = 'id_card'; ?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/student_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Minha Carteirinha de Estudante</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <button type="button" class="btn btn-sm btn-outline-secondary me-2" onclick="window.print()">
                        <i class="fas fa-print me-2"></i>Imprimir
                    </button>
                    <button type="button" class="btn btn-sm btn-primary" onclick="downloadPDF()">
                        <i class="fas fa-file-pdf me-2"></i>Baixar PDF
                    </button>
                </div>
            </div>

            <div class="alert alert-info">
                <i class="fas fa-info-circle me-2"></i>
                Esta carteirinha é válida por <?php echo get_setting('id_card_validity_months'); ?> meses a partir da data de emissão.
            </div>

            <div class="row justify-content-center mt-5">
                <div class="col-md-8 text-center">
                    <div id="id-card-container" class="d-inline-block position-relative shadow-lg" style="width: 600px; height: 380px; background-color: #fff; border-radius: 15px; overflow: hidden;">
                        
                        <!-- Background Front -->
                        <?php if (get_setting('id_card_bg_front')): ?>
                            <img src="<?php echo url('uploads/' . get_setting('id_card_bg_front')); ?>" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; z-index: 1;">
                        <?php else: ?>
                            <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: linear-gradient(135deg, <?php echo get_setting('id_card_layout_color'); ?> 0%, #ffffff 100%); z-index: 1;"></div>
                        <?php endif; ?>

                        <!-- Content Layer -->
                        <div class="position-relative w-100 h-100 p-4 text-start" style="z-index: 2; color: <?php echo get_setting('id_card_text_color'); ?>;">
                            
                            <!-- Header -->
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h3 class="fw-bold m-0" style="text-transform: uppercase; font-size: 1.5rem; text-shadow: 1px 1px 2px rgba(255,255,255,0.8);">
                                    <?php echo get_setting('id_card_school_name'); ?>
                                </h3>
                                <span class="badge bg-warning text-dark fs-6">ESTUDANTE</span>
                            </div>

                            <div class="row g-0">
                                <!-- Photo -->
                                <div class="col-4 text-center">
                                    <div class="bg-white p-1 rounded shadow-sm d-inline-block">
                                        <?php if ($user['avatar'] && file_exists('uploads/' . $user['avatar'])): ?>
                                            <img src="<?php echo url('uploads/' . $user['avatar']); ?>" class="img-fluid rounded" style="width: 120px; height: 150px; object-fit: cover; border: 1px solid #ddd;">
                                        <?php else: ?>
                                            <img src="https://ui-avatars.com/api/?name=<?php echo urlencode($user['name']); ?>&size=150&background=random" class="img-fluid rounded" style="width: 120px; height: 150px; object-fit: cover;">
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Details -->
                                <div class="col-8 ps-3">
                                    <div class="mb-2">
                                        <small class="text-uppercase fw-bold opacity-75" style="font-size: 0.7rem;">Aluno</small>
                                        <h4 class="fw-bold m-0" style="line-height: 1.2;"><?php echo $user['name']; ?></h4>
                                    </div>

                                    <div class="row mt-3">
                                        <div class="col-6">
                                            <small class="text-uppercase fw-bold opacity-75" style="font-size: 0.7rem;">Matrícula</small>
                                            <p class="fw-bold m-0 fs-5"><?php echo str_pad($user['id'], 6, '0', STR_PAD_LEFT); ?></p>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-uppercase fw-bold opacity-75" style="font-size: 0.7rem;">Validade</small>
                                            <p class="fw-bold m-0 fs-5">
                                                <?php 
                                                // Assuming validity starts from registration or current year
                                                echo date('m/Y', strtotime('+' . get_setting('id_card_validity_months') . ' months')); 
                                                ?>
                                            </p>
                                        </div>
                                    </div>
                                    
                                    <!-- QR Code Placeholder -->
                                    <div class="mt-3 text-end">
                                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=<?php echo urlencode(url('verify_student/' . $user['id'])); ?>" alt="QR Code" style="width: 80px; height: 80px; mix-blend-mode: multiply;">
                                    </div>
                                </div>
                            </div>

                            <!-- Footer -->
                            <div class="position-absolute bottom-0 start-0 w-100 p-3 text-center">
                                <small class="fw-bold opacity-75" style="font-size: 0.7rem;">Documento de Identificação Estudantil</small>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <!-- Print Instructions -->
            <div class="text-center mt-4 d-print-none">
                <p class="text-muted">Para imprimir, utilize papel de gramatura alta ou PVC para melhor durabilidade.</p>
            </div>

        </main>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
<script>
function downloadPDF() {
    const element = document.getElementById('id-card-container');
    const opt = {
        margin:       10,
        filename:     'carteirinha-estudante.pdf',
        image:        { type: 'jpeg', quality: 0.98 },
        html2canvas:  { scale: 2, useCORS: true },
        jsPDF:        { unit: 'mm', format: 'a4', orientation: 'portrait' }
    };

    // Use html2pdf to generate and download
    html2pdf().set(opt).from(element).save();
}
</script>

<style>
    @media print {
        body * {
            visibility: hidden;
        }
        #id-card-container, #id-card-container * {
            visibility: visible;
        }
        #id-card-container {
            position: fixed;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            border: 1px solid #ccc !important;
            -webkit-print-color-adjust: exact;
        }
        .sidebar, header, footer {
            display: none !important;
        }
    }
</style>

<?php require 'views/layouts/footer.php'; ?>
