<?php 
$activePage = 'history';
require 'views/layouts/header.php'; 
?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/student_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-4 border-bottom">
                <h1 class="h2">Histórico de Compras</h1>
            </div>

            <div class="card border-0 shadow-sm">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th class="border-0 px-4 py-3">Data</th>
                                    <th class="border-0 px-4 py-3">Curso</th>
                                    <th class="border-0 px-4 py-3">Valor</th>
                                    <th class="border-0 px-4 py-3">Método</th>
                                    <th class="border-0 px-4 py-3">Status</th>
                                    <th class="border-0 px-4 py-3">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($orders)): ?>
                                    <?php foreach($orders as $order): ?>
                                    <tr>
                                        <td class="px-4 py-3">
                                            <div class="d-flex align-items-center">
                                                <i class="far fa-calendar-alt text-muted me-2"></i>
                                                <?php echo date('d/m/Y', strtotime($order['created_at'])); ?>
                                            </div>
                                            <small class="text-muted ps-4"><?php echo date('H:i', strtotime($order['created_at'])); ?></small>
                                        </td>
                                        <td class="px-4 py-3 fw-bold text-primary">
                                            <?php echo $order['course_title']; ?>
                                        </td>
                                        <td class="px-4 py-3">
                                            R$ <?php echo number_format($order['amount'], 2, ',', '.'); ?>
                                        </td>
                                        <td class="px-4 py-3">
                                            <?php 
                                            $methodIcons = [
                                                'pix' => 'fa-qrcode',
                                                'credit_card' => 'fa-credit-card',
                                                'boleto' => 'fa-barcode'
                                            ];
                                            $icon = $methodIcons[$order['payment_method']] ?? 'fa-money-bill';
                                            ?>
                                            <span class="text-capitalize">
                                                <i class="fas <?php echo $icon; ?> me-1 text-muted"></i>
                                                <?php echo ucfirst($order['payment_method'] ?? 'N/A'); ?>
                                            </span>
                                        </td>
                                        <td class="px-4 py-3">
                                            <?php 
                                            $statusConfig = [
                                                'pending' => ['color' => 'warning', 'label' => 'Pendente', 'icon' => 'fa-clock'],
                                                'approved' => ['color' => 'success', 'label' => 'Aprovado', 'icon' => 'fa-check-circle'],
                                                'rejected' => ['color' => 'danger', 'label' => 'Rejeitado', 'icon' => 'fa-times-circle'],
                                                'refunded' => ['color' => 'secondary', 'label' => 'Reembolsado', 'icon' => 'fa-undo']
                                            ];
                                            $config = $statusConfig[$order['status']] ?? ['color' => 'secondary', 'label' => $order['status'], 'icon' => 'fa-question'];
                                            ?>
                                            <span class="badge bg-<?php echo $config['color']; ?>-subtle text-<?php echo $config['color']; ?> border border-<?php echo $config['color']; ?>-subtle rounded-pill px-3">
                                                <i class="fas <?php echo $config['icon']; ?> me-1"></i>
                                                <?php echo $config['label']; ?>
                                            </span>
                                        </td>
                                        <td class="px-4 py-3">
                                            <?php if ($order['status'] === 'approved'): ?>
                                                <a href="<?php echo url('student/classroom/' . $order['course_id']); ?>" class="btn btn-sm btn-outline-primary">
                                                    Acessar
                                                </a>
                                            <?php elseif ($order['status'] === 'pending'): ?>
                                                <a href="<?php echo $order['payment_link'] ?? '#'; ?>" target="_blank" class="btn btn-sm btn-primary">
                                                    Pagar
                                                </a>
                                            <?php else: ?>
                                                <button class="btn btn-sm btn-light" disabled>Indisponível</button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center py-5">
                                            <i class="fas fa-shopping-cart fa-3x text-muted mb-3 opacity-50"></i>
                                            <p class="text-muted mb-0">Nenhuma compra realizada ainda.</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
