<?php require 'views/layouts/header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar de Módulos (Esquerda) -->
        <div class="col-md-3 bg-white border-end sidebar-module py-3" style="height: calc(100vh - 56px); overflow-y: auto;">
            <div class="d-flex align-items-center justify-content-between mb-3 px-2">
                <h6 class="mb-0 fw-bold text-uppercase text-muted small">Conteúdo do Curso</h6>
                <a href="<?php echo url('student/my_courses'); ?>" class="btn btn-sm btn-outline-secondary" title="Voltar para Meus Cursos">
                    <i class="fas fa-arrow-left"></i>
                </a>
            </div>
            
            <div class="progress mb-3 mx-2" style="height: 6px;">
                <div class="progress-bar bg-success rounded-pill" role="progressbar" style="width: <?php echo $course['progress']; ?>%;" aria-valuenow="<?php echo $course['progress']; ?>" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <p class="text-muted small px-2 mb-3"><?php echo $course['progress']; ?>% concluído</p>

            <div class="accordion accordion-flush" id="accordionClassroom">
                <?php if (count($modules) > 0): ?>
                    <?php foreach ($modules as $index => $module): ?>
                    <div class="accordion-item border-0">
                        <h2 class="accordion-header" id="heading<?php echo $module['id']; ?>">
                            <button class="accordion-button bg-light rounded-3 mb-1" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $module['id']; ?>" aria-expanded="true">
                                <span class="fw-bold"><?php echo $module['title']; ?></span>
                            </button>
                        </h2>
                        <div id="collapse<?php echo $module['id']; ?>" class="accordion-collapse collapse show">
                            <div class="accordion-body p-0">
                                <ul class="list-group list-group-flush">
                                    <?php foreach($module['lessons'] as $lesson): ?>
                                    <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center border-0 rounded-2 mb-1 p-2 lesson-item" 
                                        style="cursor: pointer;" 
                                        onclick='loadLesson(<?php echo htmlspecialchars(json_encode($lesson), ENT_QUOTES, "UTF-8"); ?>)'>
                                        <div class="d-flex align-items-center text-truncate" style="max-width: 85%;">
                                            <i class="fas fa-<?php echo $lesson['type'] == 'video' ? 'play-circle' : ($lesson['type'] == 'pdf' ? 'file-pdf' : 'file-alt'); ?> me-2 text-primary"></i> 
                                            <span class="small text-truncate"><?php echo $lesson['title']; ?></span>
                                            <?php if(!empty($lesson['duration'])): ?>
                                                <span class="badge bg-light text-secondary ms-1 border" style="font-size: 0.7em;"><?php echo $lesson['duration']; ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="form-check" onclick="event.stopPropagation();">
                                            <input class="form-check-input" type="checkbox" value="" id="checkLesson<?php echo $lesson['id']; ?>" 
                                                <?php echo $lesson['completed'] ? 'checked' : ''; ?> 
                                                onchange="toggleProgress(<?php echo $lesson['id']; ?>, this.checked)" title="Marcar como concluída">
                                        </div>
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="p-3 text-muted text-center">Sem módulos disponíveis.</p>
                <?php endif; ?>
            </div>

            <div class="mt-4 px-2 d-grid">
                <?php if($course['progress'] == 100): ?>
                    <a href="<?php echo url('student/certificate/' . $course['id']); ?>" target="_blank" class="btn btn-success text-white shadow-sm">
                        <i class="fas fa-certificate me-2"></i> Emitir Certificado
                    </a>
                <?php else: ?>
                    <button class="btn btn-secondary" disabled>
                        <i class="fas fa-lock me-2"></i> Certificado
                    </button>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Área de Conteúdo (Direita) -->
        <div class="col-md-9 py-4 bg-light" style="height: calc(100vh - 56px); overflow-y: auto;">
            <div class="container">
                <div id="lessonContainer" class="bg-white rounded-3 shadow-sm p-4">
                    <div class="ratio ratio-16x9 bg-dark mb-4 rounded-3 overflow-hidden" id="videoContainer">
                        <div class="d-flex flex-column align-items-center justify-content-center text-white h-100">
                            <i class="fas fa-play-circle fa-4x mb-3 opacity-75"></i>
                            <h4 class="fw-light">Selecione uma aula para começar</h4>
                        </div>
                    </div>

                    <div id="quizContainer" style="display: none;">
                        <div class="text-center py-5" id="quizStartScreen">
                            <i class="fas fa-clipboard-check fa-4x text-primary mb-3"></i>
                            <h3 id="quizTitleDisplay">Quiz</h3>
                            <p class="lead">Este módulo contém uma avaliação.</p>
                            <p id="quizInfo" class="text-muted"></p>
                            <button class="btn btn-primary btn-lg mt-3" onclick="startQuiz()">
                                <i class="fas fa-play me-2"></i> Iniciar Avaliação
                            </button>
                        </div>
                        
                        <div id="quizQuestions" style="display: none;">
                            <form id="quizForm">
                                <div id="questionsList"></div>
                                <div class="mt-4 text-end">
                                    <button type="button" class="btn btn-success btn-lg" onclick="submitQuiz()">
                                        Enviar Respostas <i class="fas fa-check ms-2"></i>
                                    </button>
                                </div>
                            </form>
                        </div>

                        <div id="quizResult" style="display: none;" class="text-center py-5">
                            <div id="resultIcon" class="mb-3"></div>
                            <h3 id="resultTitle"></h3>
                            <p id="resultScore" class="lead display-4 fw-bold"></p>
                            <p id="resultMessage"></p>
                            <button class="btn btn-outline-primary mt-3" onclick="location.reload()">
                                Continuar
                            </button>
                        </div>
                    </div>
                    
                    <div id="contentContainer" class="mb-4"></div>
                    
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <h2 id="lessonTitle" class="fw-bold mb-0"><?php echo $course['title']; ?></h2>
                        <button class="btn btn-outline-primary btn-sm" onclick="toggleComments()">
                            <i class="fas fa-comment-dots me-2"></i> Dúvidas
                        </button>
                    </div>
                    
                    <p class="text-muted"><?php echo $course['description']; ?></p>
                    
                    <hr class="my-4">
                    
                    <div id="commentsSection" style="display:none;">
                        <h4 class="mb-3">Dúvidas e Comentários</h4>
                        
                        <div class="card mb-4 border-0 shadow-sm bg-light">
                            <div class="card-body">
                                <form id="commentForm" onsubmit="submitComment(event)">
                                    <input type="hidden" id="currentLessonId" name="lesson_id">
                                    <div class="mb-3">
                                        <textarea class="form-control border-0" name="content" id="commentContent" rows="3" placeholder="Tem alguma dúvida? Pergunte aqui..." required style="resize: none;"></textarea>
                                    </div>
                                    <div class="d-flex justify-content-end">
                                        <button type="submit" class="btn btn-primary px-4">Enviar Pergunta</button>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div id="commentsList" class="vstack gap-3">
                            <!-- Comentários serão carregados aqui -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function toggleComments() {
    const section = document.getElementById('commentsSection');
    if (section.style.display === 'none') {
        section.style.display = 'block';
        section.scrollIntoView({ behavior: 'smooth' });
    } else {
        section.style.display = 'none';
    }
}

function loadLesson(lesson) {
    const id = lesson.id;
    const type = lesson.type;
    const title = lesson.title;
    const videoUrl = lesson.video_url || '';
    const content = lesson.content || '';

    document.getElementById('lessonTitle').innerText = title;
    const videoContainer = document.getElementById('videoContainer');
    const contentContainer = document.getElementById('contentContainer');
    const commentsSection = document.getElementById('commentsSection');
    const currentLessonId = document.getElementById('currentLessonId');
    
    // Highlight active lesson
    document.querySelectorAll('.lesson-item').forEach(item => item.classList.remove('bg-primary', 'bg-opacity-10', 'text-primary'));
    event.currentTarget.classList.add('bg-primary', 'bg-opacity-10', 'text-primary');
    
    currentLessonId.value = id;
    commentsSection.style.display = 'none'; // Hide comments initially when loading new lesson

    videoContainer.innerHTML = '';
    contentContainer.innerHTML = '';

    if (type === 'video') {
        videoContainer.style.display = 'block';
        document.getElementById('quizContainer').style.display = 'none';
        let embedUrl = videoUrl;
        if (videoUrl.includes('watch?v=')) {
            embedUrl = videoUrl.replace('watch?v=', 'embed/');
        } else if (videoUrl.includes('youtu.be/')) {
            embedUrl = videoUrl.replace('youtu.be/', 'www.youtube.com/embed/');
        }

        // Add parameters to hide YouTube branding/links
        const separator = embedUrl.includes('?') ? '&' : '?';
        embedUrl += separator + 'modestbranding=1&rel=0&showinfo=0&controls=1';

        videoContainer.innerHTML = `<iframe src="${embedUrl}" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>`;
    } else if (type === 'quiz' || type === 'exam') {
        videoContainer.style.display = 'none';
        contentContainer.innerHTML = '';
        document.getElementById('quizContainer').style.display = 'block';
        document.getElementById('quizStartScreen').style.display = 'block';
        document.getElementById('quizQuestions').style.display = 'none';
        document.getElementById('quizResult').style.display = 'none';
        document.getElementById('quizTitleDisplay').innerText = title;
        loadQuizInfo(id);
    } else {
        videoContainer.style.display = 'none';
        document.getElementById('quizContainer').style.display = 'none';
    }

    if (type === 'text' || type === 'pdf') {
        if (type === 'pdf') {
            contentContainer.innerHTML = `
                <div class="text-center py-5 bg-light rounded-3">
                    <i class="fas fa-file-pdf fa-3x text-danger mb-3"></i>
                    <h3>Material em PDF</h3>
                    <p class="text-muted mb-4">Clique no botão abaixo para acessar o material.</p>
                    <a href="${content}" target="_blank" class="btn btn-primary btn-lg">
                        <i class="fas fa-download me-2"></i> Baixar/Visualizar PDF
                    </a>
                </div>`;
        } else {
            contentContainer.innerHTML = `<div class="typography">${content}</div>`;
        }
    }

    loadComments(id);
}

// Auto-load first lesson
document.addEventListener('DOMContentLoaded', function() {
    const firstLesson = document.querySelector('.lesson-item');
    if (firstLesson) {
        firstLesson.click();
    }
});

let currentQuizId = null;
let currentQuestions = [];

function loadQuizInfo(lessonId) {
    currentQuizId = lessonId; // Using lessonId as identifier for now
    fetch('<?php echo url('student/get_quiz?lesson_id='); ?>' + lessonId)
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                document.getElementById('quizInfo').innerText = "Erro ao carregar avaliação: " + data.error;
                return;
            }
            const quiz = data.quiz;
            currentQuestions = data.questions;
            let info = `Tempo Limite: ${quiz.time_limit} min | Nota Mínima: ${quiz.passing_score} pts`;
            document.getElementById('quizInfo').innerText = info;
        })
        .catch(err => console.error(err));
}

function startQuiz() {
    document.getElementById('quizStartScreen').style.display = 'none';
    document.getElementById('quizQuestions').style.display = 'block';
    
    const container = document.getElementById('questionsList');
    container.innerHTML = '';
    
    currentQuestions.forEach((q, index) => {
        let html = `
            <div class="card mb-3 border-0 shadow-sm">
                <div class="card-body">
                    <h5 class="card-title text-primary">Questão ${index + 1} <small class="text-muted ms-2" style="font-size: 0.8rem;">(${q.points} pts)</small></h5>
                    <p class="card-text fs-5">${q.question_text}</p>
                    <div class="mt-3">
        `;
        
        if (q.question_type === 'multiple_choice') {
            q.options.forEach(opt => {
                html += `
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="q_${q.id}" id="opt_${opt.id}" value="${opt.id}">
                        <label class="form-check-label" for="opt_${opt.id}">
                            ${opt.option_text}
                        </label>
                    </div>
                `;
            });
        } else if (q.question_type === 'text') {
            html += `
                <textarea class="form-control" name="q_${q.id}" rows="3" placeholder="Sua resposta..."></textarea>
            `;
        }
        
        html += `
                    </div>
                </div>
            </div>
        `;
        container.innerHTML += html;
    });
}

function submitQuiz() {
    const form = document.getElementById('quizForm');
    const formData = new FormData(form);
    const answers = {};
    
    currentQuestions.forEach(q => {
        if (q.question_type === 'multiple_choice') {
            // Check undefined vs null vs value
            let val = formData.get(`q_${q.id}`);
            if(val) answers[q.id] = val;
        } else {
            let val = formData.get(`q_${q.id}`);
            if(val) answers[q.id] = val;
        }
    });

    if (Object.keys(answers).length < currentQuestions.length) {
        if (!confirm('Você deixou algumas perguntas em branco. Deseja enviar mesmo assim?')) return;
    }

    fetch('<?php echo url('student/submit_quiz'); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            lesson_id: currentQuizId,
            answers: answers
        })
    })
    .then(response => response.json())
    .then(result => {
        if (result.error) {
            alert(result.error);
            return;
        }
        
        document.getElementById('quizQuestions').style.display = 'none';
        document.getElementById('quizResult').style.display = 'block';
        
        const iconDiv = document.getElementById('resultIcon');
        const title = document.getElementById('resultTitle');
        const score = document.getElementById('resultScore');
        const msg = document.getElementById('resultMessage');
        
        if (result.passed) {
            iconDiv.innerHTML = '<i class="fas fa-check-circle fa-5x text-success"></i>';
            title.innerText = 'Parabéns!';
            title.className = 'text-success fw-bold';
            msg.innerText = 'Você atingiu a pontuação necessária.';
            
            // Mark as completed in sidebar
            const check = document.getElementById(`checkLesson${currentQuizId}`);
            if (check) check.checked = true;
        } else {
            iconDiv.innerHTML = '<i class="fas fa-times-circle fa-5x text-danger"></i>';
            title.innerText = 'Não foi dessa vez...';
            title.className = 'text-danger fw-bold';
            msg.innerText = 'Você não atingiu a pontuação mínima. Tente novamente!';
        }
        
        score.innerText = `${result.score} / ${result.total_points}`;
    })
    .catch(err => {
        console.error(err);
        alert('Erro ao enviar respostas.');
    });
}

function loadComments(lessonId) {
    fetch('<?php echo url('student/get_comments?lesson_id='); ?>' + lessonId)
    .then(response => response.json())
    .then(data => {
        const list = document.getElementById('commentsList');
        list.innerHTML = '';
        if (data.length === 0) {
            list.innerHTML = '<p class="text-muted text-center my-3">Nenhum comentário ainda. Seja o primeiro a perguntar!</p>';
        } else {
            data.forEach(comment => {
                const isTeacher = comment.user_role === 'professor' || comment.user_role === 'admin';
                const badge = isTeacher ? '<span class="badge bg-primary ms-2">Professor</span>' : '';
                const bgClass = isTeacher ? 'bg-primary bg-opacity-10 border-primary border-opacity-25' : 'bg-white';
                
                list.innerHTML += `
                    <div class="card border-0 shadow-sm ${bgClass}">
                        <div class="card-body py-3">
                            <div class="d-flex justify-content-between mb-2">
                                <div>
                                    <strong class="text-dark">${comment.user_name}</strong>
                                    ${badge}
                                </div>
                                <small class="text-muted">${new Date(comment.created_at).toLocaleDateString()}</small>
                            </div>
                            <p class="mb-0 text-secondary">${comment.content}</p>
                        </div>
                    </div>
                `;
            });
        }
    });
}

function submitComment(e) {
    e.preventDefault();
    const lessonId = document.getElementById('currentLessonId').value;
    const content = document.getElementById('commentContent').value;
    
    if(!lessonId) {
        alert('Selecione uma aula primeiro.');
        return;
    }

    fetch('<?php echo url('student/save_comment'); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `lesson_id=${lessonId}&content=${encodeURIComponent(content)}`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('commentContent').value = '';
            loadComments(lessonId);
        } else {
            alert('Erro ao enviar comentário');
        }
    });
}

function toggleProgress(lessonId, isChecked) {
    fetch('<?php echo url('student/toggle_progress'); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `lesson_id=${lessonId}&completed=${isChecked}`
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            console.log('Progresso salvo');
            // Opcional: Atualizar barra de progresso geral via reload ou JS calculation
            // location.reload(); // Simples mas brusco
        } else {
            alert('Erro ao salvar progresso');
        }
    });
}
</script>

<?php require 'views/layouts/footer.php'; ?>
