<?php require 'views/layouts/header.php'; ?>
<?php $activePage = 'dashboard'; ?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/professor_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Painel do Professor</h1>
            </div>

            <!-- Stats Cards -->
            <div class="row g-4 mb-4">
                <div class="col-md-4">
                    <div class="card h-100 border-start border-4 border-primary">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted mb-1 text-uppercase fw-bold" style="font-size: 0.8rem;">Meus Cursos</p>
                                    <h3 class="mb-0 fw-bold"><?php echo isset($courses) ? count($courses) : 0; ?></h3>
                                </div>
                                <div class="icon-shape bg-primary text-white rounded p-3">
                                    <i class="fas fa-book-open fa-lg"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card h-100 border-start border-4 border-success">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted mb-1 text-uppercase fw-bold" style="font-size: 0.8rem;">Alunos Matriculados</p>
                                    <h3 class="mb-0 fw-bold"><?php echo isset($totalStudents) ? $totalStudents : 0; ?></h3>
                                </div>
                                <div class="icon-shape bg-success text-white rounded p-3">
                                    <i class="fas fa-user-graduate fa-lg"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card h-100 border-start border-4 border-warning">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <p class="text-muted mb-1 text-uppercase fw-bold" style="font-size: 0.8rem;">Ganhos Totais</p>
                                    <h3 class="mb-0 fw-bold">R$ <?php echo isset($totalEarnings) ? number_format($totalEarnings, 2, ',', '.') : '0,00'; ?></h3>
                                </div>
                                <div class="icon-shape bg-warning text-white rounded p-3">
                                    <i class="fas fa-dollar-sign fa-lg"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-8">
                    <div class="card mb-4 shadow-sm">
                        <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-primary"><i class="fas fa-chart-bar me-2"></i>Desempenho Mensal</h5>
                        </div>
                        <div class="card-body">
                            <canvas id="performanceChart" width="100%" height="40"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card mb-4 shadow-sm">
                        <div class="card-header bg-transparent">
                            <h5 class="mb-0 text-primary"><i class="fas fa-bolt me-2"></i>Ações Rápidas</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="<?php echo url('professor/create_course'); ?>" class="btn btn-primary btn-lg">
                                    <i class="fas fa-plus-circle me-2"></i> Criar Novo Curso
                                </a>
                                <a href="<?php echo url('professor/students'); ?>" class="btn btn-outline-secondary">
                                    <i class="fas fa-envelope me-2"></i> Enviar Mensagem
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </main>
    </div>
</div>

<script>
    const ctxPerf = document.getElementById('performanceChart').getContext('2d');
    const performanceChart = new Chart(ctxPerf, {
        type: 'bar',
        data: {
            labels: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun'],
            datasets: [{
                label: 'Ganhos (R$)',
                data: [500, 1200, 900, 1500, 2000, <?php echo isset($totalEarnings) && $totalEarnings > 0 ? $totalEarnings : 2500; ?>],
                backgroundColor: 'rgba(111, 66, 193, 0.6)',
                borderColor: '#6f42c1',
                borderWidth: 1,
                borderRadius: 5
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        borderDash: [2, 4],
                        color: '#e9ecef'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });
</script>

<?php require 'views/layouts/footer.php'; ?>
