<?php require 'views/layouts/header.php'; ?>

<div class="container mt-4">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo url('professor/courses'); ?>">Meus Cursos</a></li>
            <li class="breadcrumb-item active" aria-current="page">Novo Curso</li>
        </ol>
    </nav>

    <h2>Criar Novo Curso</h2>
    
    <div class="card mt-3">
        <div class="card-body">
            <form action="<?php echo url('professor/create_course'); ?>" method="POST" enctype="multipart/form-data">
                <div class="mb-3">
                    <label class="form-label">Título do Curso</label>
                    <input type="text" name="title" class="form-control" required>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Categoria</label>
                    <select name="category_id" class="form-select" required>
                        <option value="">Selecione...</option>
                        <?php foreach($categories as $cat): ?>
                            <option value="<?php echo $cat['id']; ?>"><?php echo $cat['name']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Preço (R$)</label>
                        <input type="number" name="price" class="form-control" step="0.01" min="0" value="0.00" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Carga Horária (Ex: 20 Horas)</label>
                        <input type="text" name="duration" class="form-control" placeholder="Ex: 20 Horas">
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label">Imagem de Capa</label>
                    <input type="file" name="image" class="form-control" accept="image/*">
                </div>

                <div class="mb-3">
                    <label class="form-label">Descrição</label>
                    <textarea name="description" class="form-control" rows="5"></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">O que vou aprender?</label>
                    <textarea name="what_will_i_learn" class="form-control" rows="4" placeholder="Liste os principais tópicos e habilidades que o aluno irá desenvolver."></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">Público-alvo</label>
                    <textarea name="target_audience" class="form-control" rows="3" placeholder="Para quem é este curso? Ex: Iniciantes em programação, Profissionais de marketing, etc."></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">Requisitos</label>
                    <textarea name="requirements" class="form-control" rows="3" placeholder="O que é necessário saber ou ter antes de começar? Ex: Conhecimento básico de inglês, Computador com acesso à internet."></textarea>
                </div>

                <button type="submit" class="btn btn-success">Criar Curso</button>
            </form>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
