<?php require 'views/layouts/header.php'; ?>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Meus Cursos</h2>
        <a href="<?php echo url('professor/create_course'); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> Novo Curso</a>
    </div>

    <?php if (count($courses) > 0): ?>
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>Imagem</th>
                        <th>Título</th>
                        <th>Preço</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($courses as $course): ?>
                        <tr>
                            <td width="100">
                                <?php if($course['image']): ?>
                                    <img src="<?php echo asset('uploads/' . $course['image']); ?>" alt="Img" class="img-thumbnail" style="height: 50px;">
                                <?php else: ?>
                                    <span class="text-muted">Sem img</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $course['title']; ?></td>
                            <td>R$ <?php echo number_format($course['price'], 2, ',', '.'); ?></td>
                            <td>
                                <?php 
                                $badgeClass = match($course['status']) {
                                    'published' => 'bg-success',
                                    'draft' => 'bg-warning text-dark',
                                    'archived' => 'bg-secondary',
                                    default => 'bg-secondary'
                                };
                                ?>
                                <span class="badge <?php echo $badgeClass; ?>"><?php echo ucfirst($course['status']); ?></span>
                            </td>
                            <td>
                                <a href="<?php echo url('professor/edit_course/' . $course['id']); ?>" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i> Editar</a>
                                <a href="<?php echo url('professor/modules/' . $course['id']); ?>" class="btn btn-sm btn-info text-white"><i class="fas fa-layer-group"></i> Conteúdo</a>
                                <a href="<?php echo url('course/show/' . $course['id']); ?>" target="_blank" class="btn btn-sm btn-outline-secondary"><i class="fas fa-eye"></i> Ver</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-info">
            Você ainda não criou nenhum curso. <a href="<?php echo url('professor/create_course'); ?>">Crie o primeiro agora!</a>
        </div>
    <?php endif; ?>
</div>

<?php require 'views/layouts/footer.php'; ?>
