<?php require 'views/layouts/home_header.php'; ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <h1 class="fw-bold text-primary mb-4">Sobre Nós</h1>
            
            <div class="bg-white p-5 rounded shadow-sm mb-5">
                <p class="lead mb-4">
                    Bem-vindo à <?php echo get_setting('site_name') ?: 'PortalEduca'; ?>, sua plataforma de ensino a distância dedicada a transformar vidas através da educação.
                </p>
                <p>
                    Nossa missão é democratizar o acesso ao conhecimento, oferecendo cursos de alta qualidade, acessíveis e flexíveis para que você possa estudar no seu ritmo e onde estiver.
                </p>
                <p>
                    Com uma equipe de professores qualificados e uma metodologia moderna, buscamos proporcionar a melhor experiência de aprendizado, preparando nossos alunos para os desafios do mercado de trabalho e para o crescimento pessoal.
                </p>
            </div>

            <div class="row g-4 text-center">
                <div class="col-md-4">
                    <div class="p-4 bg-white rounded shadow-sm h-100">
                        <i class="fas fa-bullseye fa-3x text-primary mb-3"></i>
                        <h4 class="fw-bold">Missão</h4>
                        <p class="text-muted small">Levar educação de qualidade a todos, superando barreiras geográficas e econômicas.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="p-4 bg-white rounded shadow-sm h-100">
                        <i class="fas fa-eye fa-3x text-success mb-3"></i>
                        <h4 class="fw-bold">Visão</h4>
                        <p class="text-muted small">Ser referência em ensino online, reconhecida pela excelência e inovação.</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="p-4 bg-white rounded shadow-sm h-100">
                        <i class="fas fa-heart fa-3x text-danger mb-3"></i>
                        <h4 class="fw-bold">Valores</h4>
                        <p class="text-muted small">Ética, comprometimento, inovação e foco no aluno.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
