    </div>
    
    <!-- Footer Style -->
    <style>
        .footer-dark {
            background-color: #212529;
            color: #f8f9fa;
            padding-top: 60px;
            padding-bottom: 20px;
            font-size: 0.95rem;
        }
        .footer-dark h5 {
            color: #fff;
            font-weight: bold;
            margin-bottom: 25px;
            font-size: 1.1rem;
        }
        .footer-dark ul {
            padding: 0;
            list-style: none;
        }
        .footer-dark ul li {
            margin-bottom: 12px;
        }
        .footer-dark ul li a {
            color: #ccc;
            text-decoration: none;
            transition: color 0.3s;
        }
        .footer-dark ul li a:hover {
            color: #fff;
            text-decoration: underline;
        }
        .footer-dark .logo-container img {
            max-width: 100%;
            height: auto;
            margin-bottom: 20px;
        }
        .footer-dark .contact-info p {
            margin-bottom: 8px;
            color: #ccc;
            font-size: 0.9rem;
        }
        .whatsapp-float {
            position: fixed;
            width: 60px;
            height: 60px;
            bottom: 25px;
            right: 25px;
            background-color: #25d366;
            color: #FFF;
            border-radius: 50px;
            text-align: center;
            font-size: 30px;
            box-shadow: 2px 2px 3px #999;
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }
        .whatsapp-float:hover {
            background-color: #128C7E;
            color: #FFF;
            transform: scale(1.1);
        }
    </style>

    <footer class="footer-dark mt-auto">
        <?php
        // Fetch footer links dynamically
        global $pdo;
        $footer_links_db = [];
        if(isset($pdo)) {
            try {
                $stmt = $pdo->query("SELECT * FROM footer_links ORDER BY column_number, order_index");
                $all_links = $stmt->fetchAll(PDO::FETCH_ASSOC);
                foreach($all_links as $link) {
                    $footer_links_db[$link['column_number']][] = $link;
                }
            } catch (Exception $e) {
                // Fail silently if table doesn't exist yet
            }
        }
        ?>
        <div class="container">
            <div class="row">
                <!-- Coluna 1 -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5><?php echo get_setting('footer_col1_title') ?: 'Aprendizado'; ?></h5>
                    <?php if(!empty($footer_links_db[1])): ?>
                        <ul>
                            <?php foreach($footer_links_db[1] as $link): ?>
                                <li><a href="<?php echo htmlspecialchars($link['url']); ?>"><?php echo htmlspecialchars($link['label']); ?></a></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php elseif(get_setting('footer_col1_content')): ?>
                        <div class="footer-links"><?php echo get_setting('footer_col1_content'); ?></div>
                    <?php else: ?>
                    <ul>
                        <li><a href="<?php echo url('courses'); ?>">Cursos Online</a></li>
                        <li><a href="<?php echo url('courses'); ?>">Cursos Grátis</a></li>
                        <li><a href="#">Conteúdos Gratuitos</a></li>
                        <li><a href="#">Blog</a></li>
                        <li><a href="#">Sugerir novo curso</a></li>
                        <li><a href="<?php echo url('validate_certificate'); ?>">Certificados</a></li>
                    </ul>
                    <?php endif; ?>
                </div>

                <!-- Coluna 2 -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5><?php echo get_setting('footer_col2_title') ?: 'Institucional'; ?></h5>
                    <?php if(!empty($footer_links_db[2])): ?>
                        <ul>
                            <?php foreach($footer_links_db[2] as $link): ?>
                                <li><a href="<?php echo htmlspecialchars($link['url']); ?>"><?php echo htmlspecialchars($link['label']); ?></a></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php elseif(get_setting('footer_col2_content')): ?>
                        <div class="footer-links"><?php echo get_setting('footer_col2_content'); ?></div>
                    <?php else: ?>
                    <ul>
                        <li><a href="#">Sobre Nós</a></li>
                        <li><a href="#">Como Funciona</a></li>
                        <li><a href="#">Perguntas frequentes</a></li>
                        <li><a href="#">Contato</a></li>
                        <li><a href="<?php echo url('validate_certificate'); ?>">Consultar certificados</a></li>
                        <li><a href="#">Programa Fidelidade</a></li>
                    </ul>
                    <?php endif; ?>
                </div>

                <!-- Coluna 3 -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h5><?php echo get_setting('footer_col3_title') ?: 'Informações'; ?></h5>
                    <?php if(!empty($footer_links_db[3])): ?>
                        <ul>
                            <?php foreach($footer_links_db[3] as $link): ?>
                                <li><a href="<?php echo htmlspecialchars($link['url']); ?>"><?php echo htmlspecialchars($link['label']); ?></a></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php elseif(get_setting('footer_col3_content')): ?>
                        <div class="footer-links"><?php echo get_setting('footer_col3_content'); ?></div>
                    <?php else: ?>
                    <ul>
                        <li><a href="#">Política de Privacidade</a></li>
                        <li><a href="#">Responsabilidade Social</a></li>
                        <li><a href="#">Motivação para dias difíceis</a></li>
                        <li><a href="#">Mapa do Site</a></li>
                    </ul>
                    <?php endif; ?>
                </div>

                <!-- Coluna 4: Logo e Dados -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="logo-container">
                         <div class="mb-3 text-white fw-bold d-flex align-items-center">
                            <i class="fas fa-graduation-cap fa-3x me-2"></i>
                            <div style="line-height: 1.1;">
                                <div style="font-size: 1.5rem;"><?php echo get_setting('footer_logo_text_1') ?: 'CURSOS'; ?></div>
                                <div style="font-size: 0.9rem; letter-spacing: 2px;"><?php echo get_setting('footer_logo_text_2') ?: 'ONLINE'; ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="contact-info">
                        <p><?php echo get_setting('footer_address') ?: 'Rua Fictícia, 50/38. Bairro Centro'; ?></p>
                        <p><?php echo get_setting('footer_city_state') ?: 'São Paulo/SP – Cep: 01000-000'; ?></p>
                        <p><?php echo get_setting('footer_email') ?: 'contato@cursosonline.com.br'; ?></p>
                        <p>CNPJ: <?php echo get_setting('footer_cnpj') ?: '00.000.000/0001-00'; ?></p>
                    </div>
                </div>
            </div>

            <hr class="my-4" style="border-color: rgba(255,255,255,0.1);">

            <div class="text-center pb-3">
                <p class="mb-0">&copy; <?php echo date('Y'); ?> <?php echo defined('SITE_NAME') ? SITE_NAME : 'Cursos Online'; ?> – Todos os direitos reservados</p>
            </div>
        </div>
    </footer>

    <!-- WhatsApp Button -->
    <?php if(get_setting('whatsapp_active')): ?>
    <a href="https://wa.me/<?php echo get_setting('whatsapp_number'); ?>?text=<?php echo urlencode(get_setting('whatsapp_message') ?: 'Olá! Gostaria de mais informações.'); ?>" class="whatsapp-float" target="_blank" title="Fale conosco no WhatsApp">
        <i class="fab fa-whatsapp"></i>
    </a>
    <?php endif; ?>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Custom JS -->
    <script src="<?php echo url('assets/js/main.js'); ?>"></script>

    <!-- Cookie Consent Banner -->
    <div id="cookie-consent" class="fixed-bottom bg-black text-white p-4 shadow-lg" style="display: none; z-index: 9999; border-top: 1px solid #333;">
        <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
            <p class="mb-3 mb-md-0 me-md-4 text-center text-md-start fs-5">
                Este site utiliza cookies para melhorar a sua experiência. Ao continuar navegando, você concorda com a nossa <a href="#" class="text-white text-decoration-underline">Política de Privacidade</a>.
            </p>
            <button id="accept-cookies" class="btn btn-primary btn-lg px-4 fw-bold">Aceitar Cookies</button>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            if (!localStorage.getItem("cookieConsent")) {
                document.getElementById("cookie-consent").style.display = "block";
            }

            document.getElementById("accept-cookies").addEventListener("click", function() {
                localStorage.setItem("cookieConsent", "true");
                document.getElementById("cookie-consent").style.display = "none";
            });
        });
    </script>
</body>
</html>
