<?php require 'views/layouts/home_header.php'; ?>

<!-- Hero Section -->
<div class="hero-section text-white py-5" style="<?php echo get_setting('home_hero_bg') ? 'background-image: url('.url('uploads/'.get_setting('home_hero_bg')).');' : ''; ?>">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <h1 class="display-4 fw-bold mb-3"><?php echo get_setting('home_hero_title') ?: 'Matricule-se e escolha seus cursos na Sala Virtual!'; ?></h1>
                <p class="lead mb-4"><?php echo get_setting('home_hero_subtext') ?: 'Você poderá estudar quantos cursos desejar.'; ?></p>
                <a href="<?php echo get_setting('home_hero_btn_link') ?: '#cursos'; ?>" class="btn btn-warning btn-lg fw-bold text-dark px-5 py-3 rounded-pill shadow-sm hover-scale">
                    <?php echo get_setting('home_hero_btn_text') ?: 'MATRICULE-SE AGORA'; ?>
                </a>
            </div>
            <div class="col-lg-6">
                <div class="bg-white text-dark p-4 rounded-3 shadow-lg bg-opacity-95">
                    <h5 class="fw-bold text-primary mb-3"><i class="fas fa-certificate me-2"></i><?php echo get_setting('home_cert_title') ?: 'Os Certificados são válidos para:'; ?></h5>
                    <ul class="list-unstyled mb-0">
                        <?php 
                        $certItems = get_setting('home_cert_items');
                        if ($certItems) {
                            $items = explode("\n", $certItems);
                            foreach($items as $item) {
                                if(trim($item)) echo '<li class="mb-2 d-flex align-items-start"><i class="fas fa-check-circle text-success me-2 mt-1"></i><span>'.trim($item).'</span></li>';
                            }
                        } else {
                        ?>
                            <li class="mb-2 d-flex align-items-start"><i class="fas fa-check-circle text-success me-2 mt-1"></i><span>Licença Capacitação</span></li>
                            <li class="mb-2 d-flex align-items-start"><i class="fas fa-check-circle text-success me-2 mt-1"></i><span>Título em Concurso Público e Processos Seletivos</span></li>
                            <li class="mb-2 d-flex align-items-start"><i class="fas fa-check-circle text-success me-2 mt-1"></i><span>Contagem de Carga Horária para Estágio</span></li>
                            <li class="mb-2 d-flex align-items-start"><i class="fas fa-check-circle text-success me-2 mt-1"></i><span>Titularidade para Professores</span></li>
                            <li class="mb-2 d-flex align-items-start"><i class="fas fa-check-circle text-success me-2 mt-1"></i><span>Ascensão de Carreira ou Cargo</span></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Stats Section -->
<div class="stats-section py-5">
    <div class="container">
        <div class="row text-center g-4 justify-content-center">
            <div class="col-md-4">
                <div class="stat-card p-4 h-100">
                    <div class="icon-wrapper mb-3">
                        <i class="fas fa-book-open fa-3x text-primary"></i>
                    </div>
                    <h2 class="fw-bold text-dark mb-1 counter"><?php echo get_setting('stat_courses_count') ?: '2.362'; ?></h2>
                    <p class="text-muted text-uppercase small fw-bold letter-spacing-1"><?php echo get_setting('stat_courses_label') ?: 'Cursos Disponíveis'; ?></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card p-4 h-100 border-start-md border-end-md">
                    <div class="icon-wrapper mb-3">
                        <i class="fas fa-users fa-3x text-success"></i>
                    </div>
                    <h2 class="fw-bold text-dark mb-1 counter"><?php echo get_setting('stat_students_count') ?: '112.126'; ?></h2>
                    <p class="text-muted text-uppercase small fw-bold letter-spacing-1"><?php echo get_setting('stat_students_label') ?: 'Estudantes Matriculados'; ?></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card p-4 h-100">
                    <div class="icon-wrapper mb-3">
                        <i class="fas fa-graduation-cap fa-3x text-warning"></i>
                    </div>
                    <h2 class="fw-bold text-dark mb-1 counter"><?php echo get_setting('stat_certificates_count') ?: '118.092'; ?></h2>
                    <p class="text-muted text-uppercase small fw-bold letter-spacing-1"><?php echo get_setting('stat_certificates_label') ?: 'Certificados Emitidos'; ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Categories Section -->
<div class="py-5 bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold">Navegue por Categorias</h2>
        </div>
        <div class="row g-3 justify-content-center">
            <?php 
            $homeCats = get_categories_helper();
            if (!empty($homeCats)):
                foreach($homeCats as $cat):
            ?>
            <div class="col-6 col-md-4 col-lg-3">
                <a href="<?php echo url('courses?category=' . $cat['id']); ?>" class="card h-100 text-decoration-none shadow-sm hover-translate transition-all border-0">
                    <div class="card-body text-center d-flex align-items-center justify-content-center p-4">
                        <h5 class="fw-bold text-dark m-0"><?php echo htmlspecialchars($cat['name']); ?></h5>
                    </div>
                </a>
            </div>
            <?php 
                endforeach;
            endif;
            ?>
        </div>
    </div>
</div>

<?php 
$middleAds = get_ads('home_middle');
if(!empty($middleAds)): ?>
    <div class="container my-4">
        <div class="row">
            <?php foreach($middleAds as $ad): ?>
                <div class="col-12 text-center mb-3">
                    <a href="<?php echo $ad['link']; ?>" target="_blank">
                        <img src="<?php echo url('uploads/' . $ad['image']); ?>" class="img-fluid rounded shadow-sm" alt="<?php echo $ad['title']; ?>">
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>

<!-- Popular Courses Section -->
<div class="container my-5 pt-4">
    <div class="text-center mb-5">
        <h2 class="fw-bold display-6 mb-3">Cursos mais Procurados</h2>
        <p class="lead text-muted mx-auto" style="max-width: 700px;">Confira abaixo a lista dos cursos mais buscados por profissionais espalhados por todo o país</p>
    </div>

    <style>
        .nav-tabs-custom .nav-link {
            border: none;
            color: #6c757d;
            font-weight: 600;
            padding: 0.5rem 1.5rem;
            transition: all 0.3s;
        }
        .nav-tabs-custom .nav-link:hover {
            color: #333;
        }
        .nav-tabs-custom .nav-link.active {
            color: #ff9800; /* Orange color from image */
            background: transparent;
            border-bottom: 3px solid #ff9800;
        }
        .course-card-hover {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .course-card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
        }
        .badge-course {
            position: absolute;
            top: 10px;
            left: 10px;
            background: rgba(255,255,255,0.9);
            color: #333;
            font-weight: bold;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 0.8rem;
            z-index: 1;
        }
    </style>

    <ul class="nav nav-tabs justify-content-center border-0 mb-5 nav-tabs-custom" id="popularCoursesTab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="most-popular-tab" data-bs-toggle="tab" data-bs-target="#most-popular" type="button" role="tab" aria-controls="most-popular" aria-selected="true">Mais Procurados</button>
        </li>
        <?php foreach(array_slice($categories, 0, 7) as $cat): ?>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="cat-<?php echo $cat['id']; ?>-tab" data-bs-toggle="tab" data-bs-target="#cat-<?php echo $cat['id']; ?>" type="button" role="tab" aria-controls="cat-<?php echo $cat['id']; ?>" aria-selected="false"><?php echo $cat['name']; ?></button>
        </li>
        <?php endforeach; ?>
    </ul>

    <div class="tab-content" id="popularCoursesTabContent">
        <!-- Most Popular Pane -->
        <div class="tab-pane fade show active" id="most-popular" role="tabpanel" aria-labelledby="most-popular-tab">
            <div class="row g-4">
                <?php 
                $popularCourses = array_slice($courses, 0, 4); 
                if(count($popularCourses) > 0):
                foreach($popularCourses as $course): 
                ?>
                <div class="col-md-6 col-lg-3">
                    <div class="card h-100 border-0 shadow-sm course-card-hover">
                        <div class="position-relative">
                            <span class="badge-course">Curso Online</span>
                            <?php if($course['image']): ?>
                                <img src="<?php echo url('uploads/' . $course['image']); ?>" class="card-img-top" alt="<?php echo $course['title']; ?>" style="height: 180px; object-fit: cover;">
                            <?php else: ?>
                                <div class="bg-secondary text-white d-flex align-items-center justify-content-center" style="height: 180px;">
                                    <i class="fas fa-book-open fa-3x"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <h5 class="card-title fw-bold text-dark mb-2" style="font-size: 1.1rem; min-height: 2.5em;"><?php echo mb_strimwidth($course['title'], 0, 40, "..."); ?></h5>
                            <p class="card-text text-muted small mb-3" style="min-height: 4.5em;">
                                <?php echo mb_strimwidth(strip_tags($course['description']), 0, 80, "..."); ?>
                            </p>
                            
                            <div class="d-flex align-items-center mb-2">
                                <div class="text-warning small me-2">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star-half-alt"></i>
                                </div>
                            </div>
                            
                            <div class="d-flex justify-content-between align-items-center text-muted small">
                                <span><i class="far fa-clock me-1"></i> <?php echo isset($course['duration']) && $course['duration'] ? $course['duration'] : '20 à 60 Horas'; ?></span>
                            </div>
                        </div>
                        <div class="card-footer bg-white border-0 pt-0 pb-3">
                             <a href="<?php echo url('course/' . $course['slug']); ?>" class="btn btn-outline-warning w-100 fw-bold">Ver Detalhes</a>
                        </div>
                    </div>
                </div>
                <?php endforeach; 
                else: ?>
                    <div class="col-12 text-center text-muted">Nenhum curso encontrado.</div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Category Panes -->
        <?php foreach(array_slice($categories, 0, 7) as $cat): ?>
        <div class="tab-pane fade" id="cat-<?php echo $cat['id']; ?>" role="tabpanel" aria-labelledby="cat-<?php echo $cat['id']; ?>-tab">
             <div class="row g-4">
                <?php 
                $catCourses = array_filter($courses, function($c) use ($cat) { return $c['category_id'] == $cat['id']; });
                $catCourses = array_slice($catCourses, 0, 4);
                if(count($catCourses) > 0):
                    foreach($catCourses as $course): 
                ?>
                <div class="col-md-6 col-lg-3">
                    <div class="card h-100 border-0 shadow-sm course-card-hover">
                        <div class="position-relative">
                            <span class="badge-course">Curso Online</span>
                            <?php if($course['image']): ?>
                                <img src="<?php echo url('uploads/' . $course['image']); ?>" class="card-img-top" alt="<?php echo $course['title']; ?>" style="height: 180px; object-fit: cover;">
                            <?php else: ?>
                                <div class="bg-secondary text-white d-flex align-items-center justify-content-center" style="height: 180px;">
                                    <i class="fas fa-book-open fa-3x"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <h5 class="card-title fw-bold text-dark mb-2" style="font-size: 1.1rem; min-height: 2.5em;"><?php echo mb_strimwidth($course['title'], 0, 40, "..."); ?></h5>
                            <p class="card-text text-muted small mb-3" style="min-height: 4.5em;">
                                <?php echo mb_strimwidth(strip_tags($course['description']), 0, 80, "..."); ?>
                            </p>
                            
                            <div class="d-flex align-items-center mb-2">
                                <div class="text-warning small me-2">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star-half-alt"></i>
                                </div>
                            </div>
                            
                            <div class="d-flex justify-content-between align-items-center text-muted small">
                                <span><i class="far fa-clock me-1"></i> <?php echo isset($course['duration']) && $course['duration'] ? $course['duration'] : '20 à 60 Horas'; ?></span>
                            </div>
                        </div>
                        <div class="card-footer bg-white border-0 pt-0 pb-3">
                             <a href="<?php echo url('course/' . $course['slug']); ?>" class="btn btn-outline-warning w-100 fw-bold">Ver Detalhes</a>
                        </div>
                    </div>
                </div>
                <?php endforeach;
                else:
                    echo '<div class="col-12 text-center py-5 text-muted">Nenhum curso popular nesta categoria no momento.</div>';
                endif;
                ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<div class="container my-5" id="cursos">
    <div class="row">
        <!-- Sidebar Esquerda: Categorias -->
        <div class="col-lg-3 mb-4">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-primary text-white fw-bold py-3">
                    <i class="fas fa-bars me-2"></i> Áreas de Estudo
                </div>
                <div class="list-group list-group-flush">
                    <?php if (!empty($categories)): ?>
                        <?php foreach($categories as $category): ?>
                            <a href="#" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center py-3">
                                <?php echo $category['name']; ?>
                                <i class="fas fa-chevron-right text-muted small"></i>
                            </a>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <a href="#" class="list-group-item list-group-item-action py-2">Administração</a>
                        <a href="#" class="list-group-item list-group-item-action py-2">Informática</a>
                        <a href="#" class="list-group-item list-group-item-action py-2">Idiomas</a>
                        <a href="#" class="list-group-item list-group-item-action py-2">Educação</a>
                        <a href="#" class="list-group-item list-group-item-action py-2">Saúde</a>
                    <?php endif; ?>
                </div>
            </div>

            <div class="d-grid gap-3 mb-4">
                <?php 
                $homeButtons = get_home_buttons();
                if (!empty($homeButtons)): 
                    foreach ($homeButtons as $btn):
                        // Verifica se o link é interno (não começa com http) e adiciona url()
                        $link = $btn['link'];
                        if (!preg_match('/^http/', $link) && $link !== '#') {
                            $link = url($link);
                        }
                ?>
                    <a href="<?php echo $link; ?>" class="btn <?php echo $btn['color_class']; ?> fw-bold text-start p-3 shadow-sm hover-translate transition-all <?php echo strpos($btn['color_class'], 'warning') !== false ? 'text-dark' : ''; ?>">
                        <i class="<?php echo $btn['icon']; ?> me-2 fa-lg"></i> <?php echo $btn['text']; ?>
                    </a>
                <?php 
                    endforeach;
                else: 
                ?>
                    <button class="btn btn-outline-primary fw-bold text-start p-3 shadow-sm hover-translate transition-all">
                        <i class="fas fa-language me-2 fa-lg"></i> Curso de Inglês
                    </button>
                    <button class="btn btn-outline-warning fw-bold text-start p-3 shadow-sm hover-translate transition-all text-dark">
                        <i class="fas fa-star me-2 fa-lg"></i> Todos os Cursos
                    </button>
                    <button class="btn btn-outline-success fw-bold text-start p-3 shadow-sm hover-translate transition-all">
                        <i class="fas fa-crown me-2 fa-lg"></i> Plataforma Premium
                    </button>
                <?php endif; ?>
            </div>

            <?php 
            $sidebarAds = get_ads('sidebar');
            if(!empty($sidebarAds)): ?>
                <div class="mb-4 text-center">
                    <?php foreach($sidebarAds as $ad): ?>
                        <div class="mb-3">
                            <a href="<?php echo $ad['link']; ?>" target="_blank">
                                <img src="<?php echo url('uploads/' . $ad['image']); ?>" class="img-fluid rounded shadow-sm" alt="<?php echo $ad['title']; ?>">
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Conteúdo Central: Lista de Cursos -->
        <div class="col-lg-9">
            <div class="d-flex justify-content-between align-items-center mb-4 pb-2 border-bottom">
                <h3 class="fw-bold text-primary mb-0">Cursos em Destaque</h3>
                <form class="d-flex" style="max-width: 300px;">
                    <div class="input-group">
                        <input class="form-control border-end-0" type="search" placeholder="Buscar curso..." aria-label="Search">
                        <button class="btn btn-outline-secondary border-start-0" type="submit"><i class="fas fa-search"></i></button>
                    </div>
                </form>
            </div>
            
            <div class="row g-4">
                <?php if (!empty($courses)): ?>
                    <?php foreach($courses as $course): ?>
                        <div class="col-md-4">
                            <div class="card h-100 border-0 shadow-sm hover-shadow transition-all course-card">
                                <div class="position-relative">
                                    <?php if($course['image']): ?>
                                        <img src="<?php echo url('uploads/' . $course['image']); ?>" class="card-img-top" alt="<?php echo $course['title']; ?>" style="height: 160px; object-fit: cover;">
                                    <?php else: ?>
                                        <div class="bg-light d-flex align-items-center justify-content-center" style="height: 160px;">
                                            <i class="fas fa-book fa-3x text-muted opacity-50"></i>
                                        </div>
                                    <?php endif; ?>
                                    <span class="position-absolute top-0 end-0 bg-warning text-dark fw-bold px-2 py-1 m-2 rounded small shadow-sm">
                                        R$ <?php echo number_format($course['price'], 2, ',', '.'); ?>
                                    </span>
                                </div>
                                <div class="card-body d-flex flex-column p-3">
                                    <h5 class="card-title fw-bold text-dark mb-2 text-truncate" title="<?php echo $course['title']; ?>"><?php echo $course['title']; ?></h5>
                                    <p class="card-text text-muted small flex-grow-1" style="display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden;"><?php echo $course['description']; ?></p>
                                    
                                    <div class="d-grid mt-3">
                                        <a href="<?php echo url('payment/checkout/' . $course['id']); ?>" class="btn btn-primary fw-bold text-uppercase" style="font-size: 0.85rem;">
                                            <i class="fas fa-shopping-cart me-1"></i> Matricule-se
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12 text-center py-5">
                        <div class="py-5 bg-light rounded-3">
                            <i class="fas fa-inbox fa-4x text-muted mb-3 opacity-50"></i>
                            <p class="text-muted lead">Nenhum curso disponível no momento.</p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Vantagens Section (Bottom) -->
<div class="bg-light py-5 mt-5 border-top">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold text-primary"><?php echo get_setting('advantages_title') ?: 'Por que escolher nossos cursos?'; ?></h2>
            <div class="divider mx-auto bg-warning mb-3" style="width: 60px; height: 3px;"></div>
            <p class="text-muted"><?php echo get_setting('advantages_subtitle') ?: 'Descubra as vantagens de estudar conosco'; ?></p>
        </div>
        <div class="row text-center g-4">
            <?php 
            // Definir defaults se não houver no banco
            $defaults = [
                1 => ['title' => 'Certificado Garantido', 'desc' => 'Receba seu certificado válido em todo território nacional.', 'icon' => 'fas fa-certificate', 'color' => 'primary'],
                2 => ['title' => 'Flexibilidade Total', 'desc' => 'Estude onde e quando quiser, no seu próprio ritmo.', 'icon' => 'fas fa-clock', 'color' => 'success'],
                3 => ['title' => 'Suporte Dedicado', 'desc' => 'Tire suas dúvidas diretamente com nossos tutores especializados.', 'icon' => 'fas fa-comments', 'color' => 'warning'],
                4 => ['title' => 'Sem Mensalidades', 'desc' => 'Pague uma única vez e tenha acesso vitalício ao conteúdo.', 'icon' => 'fas fa-wallet', 'color' => 'info']
            ];
            
            for($i=1; $i<=4; $i++): 
                $title = get_setting('advantage_'.$i.'_title') ?: $defaults[$i]['title'];
                $desc = get_setting('advantage_'.$i.'_desc') ?: $defaults[$i]['desc'];
                $icon = get_setting('advantage_'.$i.'_icon') ?: $defaults[$i]['icon'];
                $color = $defaults[$i]['color']; 
            ?>
            <div class="col-md-3">
                <div class="p-4 bg-white rounded shadow-sm h-100 hover-translate transition-all">
                    <div class="bg-<?php echo $color; ?> bg-opacity-10 text-<?php echo $color; ?> rounded-circle d-inline-flex p-3 mb-3">
                        <i class="<?php echo $icon; ?> fa-2x"></i>
                    </div>
                    <h5 class="fw-bold"><?php echo $title; ?></h5>
                    <p class="text-muted small"><?php echo $desc; ?></p>
                </div>
            </div>
            <?php endfor; ?>
        </div>
    </div>
</div>

<!-- Certificate Section -->
<?php if (get_setting('home_cert_active')): ?>
<div class="py-5 bg-white border-top">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <h2 class="fw-bold mb-4 display-6" style="color: #2c3e50;">
                    <?php 
                    $title = get_setting('home_cert_title');
                    // Highlight "válido" if present to match the image style
                    $highlightColor = get_setting('home_cert_color_highlight') ?: '#ffc107';
                    echo str_replace('válido', '<span style="color: '.$highlightColor.' !important;">válido</span>', $title); 
                    ?>
                </h2>
                
                <ul class="list-unstyled">
                    <?php 
                    $items = explode("\n", get_setting('home_cert_items'));
                    $iconColor = get_setting('home_cert_color_icon') ?: '#ffc107';
                    foreach ($items as $item): 
                        if (trim($item)):
                    ?>
                    <li class="mb-3 d-flex align-items-start">
                        <div class="text-white rounded-circle d-flex align-items-center justify-content-center flex-shrink-0 mt-1" style="width: 32px; height: 32px; background-color: <?php echo $iconColor; ?>;">
                            <i class="fas fa-check"></i>
                        </div>
                        <span class="ms-3 fs-5 text-secondary fw-medium"><?php echo htmlspecialchars(trim($item)); ?></span>
                    </li>
                    <?php endif; endforeach; ?>
                </ul>
            </div>
            <div class="col-lg-6 text-center">
                <?php if (get_setting('home_cert_image')): ?>
                    <div class="position-relative d-inline-block p-3 rounded-3" style="background-color: rgba(<?php echo hexdec(substr($iconColor,1,2)).','.hexdec(substr($iconColor,3,2)).','.hexdec(substr($iconColor,5,2)); ?>, 0.1);">
                        <img src="<?php echo url('uploads/' . get_setting('home_cert_image')); ?>" alt="Certificado" class="img-fluid rounded shadow-lg" style="max-height: 400px; transform: rotate(3deg); border: 8px solid #fff;">
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Validate Certificate Section -->
<div class="py-5 bg-light border-top">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-5 mb-4 mb-lg-0">
                <?php $badgeColor = get_setting('cert_color_badge') ?: '#ffc107'; ?>
                <span class="badge text-dark mb-3" style="background-color: <?php echo $badgeColor; ?>;"><?php echo get_setting('cert_security_badge') ?: 'Segurança'; ?></span>
                <h2 class="fw-bold mb-3"><?php echo get_setting('cert_security_title') ?: 'Segurança para quem emite e quem recebe o certificado'; ?></h2>
                <p class="text-muted fs-5">
                    <?php echo nl2br(get_setting('cert_security_text') ?: 'Os certificados emitidos em nossa plataforma possuem Chave única de autenticidade e QR Code. Duas garantias de validade do certificado para alunos, empresas e instituições interessadas em verificar a veracidade do mesmo.'); ?>
                </p>
            </div>
            <div class="col-lg-6 offset-lg-1">
                <div class="bg-white p-4 rounded shadow-sm">
                    <h3 class="fw-bold mb-3">Consultar Certificado</h3>
                    <form action="<?php echo url('validate_certificate'); ?>" method="GET">
                        <div class="input-group input-group-lg">
                            <input type="text" class="form-control" name="code" placeholder="Validar Certificado" required>
                            <?php $searchBtnColor = get_setting('cert_color_search_btn') ?: '#ffc107'; ?>
                            <button class="btn text-white fw-bold" type="submit" style="background-color: <?php echo $searchBtnColor; ?>; border-color: <?php echo $searchBtnColor; ?>;">Pesquisar</button>
                        </div>
                    </form>
                    
                    <?php 
                    $helpBgColor = get_setting('cert_color_help_bg') ?: '#fff3cd'; 
                    $helpBtnColor = get_setting('cert_color_help_btn') ?: '#6f42c1';
                    ?>
                    <div class="mt-4 p-3 rounded d-flex align-items-center" style="background-color: <?php echo $helpBgColor; ?>;">
                        <div class="flex-grow-1 ms-3">
                            <h5 class="fw-bold mb-1 fs-6"><?php echo get_setting('cert_help_text') ?: 'Tem alguma dúvida sobre a Plataforma?'; ?></h5>
                            <a href="<?php echo get_setting('cert_help_btn_link') ?: '#'; ?>" class="btn btn-sm text-white mt-1" style="background-color: <?php echo $helpBtnColor; ?>; border-color: <?php echo $helpBtnColor; ?>;">
                                <?php echo get_setting('cert_help_btn_text') ?: 'Buscar Informações'; ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>