<?php require 'views/layouts/header.php'; ?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="<?php echo url('admin/dashboard'); ?>" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="<?php echo url('admin/users'); ?>" class="list-group-item list-group-item-action active">Usuários</a>
            <a href="<?php echo url('admin/courses'); ?>" class="list-group-item list-group-item-action">Cursos</a>
        </div>
    </div>
    <div class="col-md-9">
        <div class="d-flex justify-content-between align-items-center">
            <h2>Gerenciar Usuários</h2>
            <a href="<?php echo url('admin/create_user'); ?>" class="btn btn-success"><i class="fas fa-plus"></i> Novo Usuário</a>
        </div>
        <table class="table table-striped mt-3">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nome</th>
                    <th>Email</th>
                    <th>Função</th>
                    <th>Data Cadastro</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php if (isset($users) && count($users) > 0): ?>
                    <?php foreach ($users as $u): ?>
                    <tr>
                        <td><?php echo $u['id']; ?></td>
                        <td><?php echo $u['name']; ?></td>
                        <td><?php echo $u['email']; ?></td>
                        <td>
                            <span class="badge bg-<?php echo ($u['role'] == 'admin' ? 'danger' : ($u['role'] == 'professor' ? 'info' : 'secondary')); ?>">
                                <?php echo ucfirst($u['role']); ?>
                            </span>
                        </td>
                        <td><?php echo date('d/m/Y', strtotime($u['created_at'])); ?></td>
                        <td>
                            <a href="<?php echo url('admin/edit_user/' . $u['id']); ?>" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a>
                            <?php if($u['id'] != $_SESSION['user_id']): ?>
                            <a href="<?php echo url('admin/delete_user/' . $u['id']); ?>" class="btn btn-sm btn-danger" onclick="return confirm('Tem certeza?')"><i class="fas fa-trash"></i></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="text-center">Nenhum usuário encontrado.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
